# == Schema Information
#
# Table name: dm_assignments
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  diagnosis_id          :integer
#  diagnosis_modifier_id :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  exam_response_fields  :string
#

class DmAssignment < ActiveRecord::Base
  include ContentManagerHelper
  belongs_to :diagnosis
  belongs_to :diagnosis_modifier

  before_validation :set_name
  after_create :append_id_to_name

  scope :order_by_position, -> () { order("position ASC") }

  FIELDS_FOR_RESULTSET = {
    0 => 'dm_assignments.name',
    1 => 'dm_assignments.label',
    2 => 'diagnoses.name',
    3 => 'diagnosis_modifiers.name'
  }

  class << self
    def filter(params={})
      query = all.joins(:diagnosis).joins(:diagnosis_modifier)

      unless params[:search][:value].blank?
        query = query.where('dm_assignments.name ilike :search OR dm_assignments.label ilike :search OR diagnoses.name ilike :search OR diagnosis_modifiers.name ilike :search', :search => "%#{params[:search][:value]}%")
      end
      query
    end
  end

  def get_diagnosis
    return self.diagnosis
  end

  def get_diagnosis_modifier
    return self.diagnosis_modifier
  end

  def build_html(identifier)
    @the_html = the_html_template_for_a_diagnosis_modifier_association
#    if self.mod_type == "checkbox"
#      @bhtml = base_without_label_html.clone
#      @bhtml.gsub!('[HTML for Modifier Type]', build_checkbox_html())
#    elsif self.mod_type == "radio"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_radio_html())
#    elsif self.mod_type == "single_select"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_single_select_html())
#    elsif self.mod_type == "multi_select"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_multi_select_html())
#    elsif self.mod_type == "date"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_date_html())
#    elsif self.mod_type == "textarea"
#      @bhtml.gsub!('[HTML for Modifier Type]', build_textarea_html())
#    end
    @the_html.gsub!('[Modifier Label]', self.label.to_s)
    @the_html.gsub!('[identifier_base]', identifier)
    @the_html.gsub!('[Modifier Name]', self.name.to_s)

    if (self.diagnosis_modifier != nil)
      @the_html.gsub!('[HTML for Modifier Type]', self.diagnosis_modifier.build_html(self.name.to_s,identifier))
    end

    return @the_html
  end

  def set_name
    if self.diagnosis.present? && self.diagnosis_modifier.present?
      self.name = clean_name(self.diagnosis.name + "_" + self.diagnosis_modifier.name)
    end
  end

  def append_id_to_name
    self.update_attribute(:name, "#{self.name}_#{self.id}")
  end


  private

    def the_html_template_for_a_diagnosis_modifier_association
      the_html_template =
        '<div id="diagnosis_modifier_container-[Modifier Name]-[identifier_base]"'    +
            ' class="container diagnosis_modifier" >'                                 +
        	'<span  id="diagnosis_modifier_label-[Modifier Name]-[identifier_base]"'    +
        	      ' class="label diagnosis_modifier">'                                  +
  		      '[Modifier Label]'                                                        +
        	'</span>'                                                                   +
          '[HTML for Modifier Type]'                                                  +
        '</div>'

      return the_html_template
    end

end
