module PointlessFeedback
  class FeedbackMailer < ActionMailer::Base
    before_filter :check_sanitize
    default from: ENV['FEEDBACK_EMAIL_USER']

    def check_sanitize()
      SanitizeEmail.force_sanitize = FEEDBACK_EMAIL_SANITIZE
    end

    default from: ENV['FEEDBACK_EMAIL_USER']

    def feedback_email(feedback, user, request_data)
      @feedback    = feedback
      @user        = user
      @request_data= request_data

      mail(   to:       ENV['FEEDBACK_EMAIL_TO'],
              subject:  "#{ENV['FEEDBACK_EMAIL_SUBJECT']} - #{@feedback[:topic]}"
          )
    end



  end
end
