class FeedbackEmailJob < ActiveJob::Base
  queue_as :default

  def perform(mailer, description, data)
    mailer = ::PointlessFeedback::FeedbackMailer.feedback_email(mailer, description, data)
    custom_smtp_settings = {
      address:              ENV['FEEDBACK_EMAIL_HOST'],
      port:                 ENV['FEEDBACK_EMAIL_PORT'],
      domain:               ENV['FEEDBACK_EMAIL_DOMAIN'],
      user_name:            ENV['FEEDBACK_EMAIL_USER'],
      password:             ENV['FEEDBACK_EMAIL_PASS'],
      authentication:       'plain',
      enable_starttls_auto: true
    }
    mailer.delivery_method.settings.merge! custom_smtp_settings
    mailer.deliver_now
  end
end
