require 'spreadsheet'

class AddExamRequestFromXls  < ActiveJob::Base

  queue_as :default

  template_path = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', 'ExamRequestTemplate.xml')
  file = File.open(template_path)
  EXAM_REQUEST_TEMPLATE = file.read

  # constant names for spreadsheet columns within a row e.g. row[xxx_COL]
  FIRST_NAME_COL      = 0
  LAST_NAME_COL       = 1
  FILE_NUM_COL        = 2
  CLAIM_ID_COL        = 3
  SITE_COL            = 4



  def perform(excel_file)
    @xls = excel_file
    #setup logger
    log = ActiveSupport::Logger.new(Rails.root.join('public', 'uploads','ExamRequestSimulator',"#{excel_file}.log"))
    start_time = Time.now.strftime('%H:%M:%S')
    log.info "--Starting @ #{start_time}"


    full_file_path = Rails.root.join('public', 'uploads','ExamRequestSimulator', @xls)
    Spreadsheet.client_encoding = 'UTF-8'
    book    = Spreadsheet.open full_file_path
    sheet0  = book.worksheet 0


    sheet0.each_with_index do |row, row_indx|

      if [FIRST_NAME_COL, LAST_NAME_COL, FILE_NUM_COL, CLAIM_ID_COL, SITE_COL].any? {|col_indx| row[col_indx].blank? }
        log.info "----Error in row ##{row_indx + 1}: missing mandatory field (first name, last name, email) in columns A thru C"
        next
      else
        contents = EXAM_REQUEST_TEMPLATE.clone
        contents.gsub! '###FIRST_NAME###', row[FIRST_NAME_COL].to_s
        contents.gsub! '###LAST_NAME###', row[LAST_NAME_COL].to_s
        contents.gsub! '###FILE_NUMBER###', row[FILE_NUM_COL].to_s
        contents.gsub! '###CLAIM_ID###', row[CLAIM_ID_COL].to_s
        contents.gsub! '###SITE###', row[SITE_COL].to_s
        log.info "---Sent row ##{row_indx + 1} to endpoint!"
        PostXmlToEndpoint.perform_later(contents)
        contents=""
      end
    end
  end


end