# app/helpers/nav_helper.rb
# Provides tab-based navigation between controllers

module NavHelper

  def user_tabs(current_user)
    tabs = []

    # show tabs that user has permission to access.
    # Keeping it simple with handcoded can? calls instead of metaprogramming, and
    # using paths instead of controller so that URLs render on feedback page.
    if can?(:index, Referral) && current_user.is_cpp_user?
      tabs << {label: 'Referrals', path: 'referrals_path'}
    end
    if can?(:index, Consultation) && current_user.is_cpp_user?
      tabs << {label: 'Consultations', path: 'consultations_path'}
    end
    return tabs
  end

  def active_tab_from_path(tab_path)
    nav_controller = controller_name_from_path(tab_path)
    return "active" if request.params[:controller].to_sym == nav_controller.to_sym
  end

private

  # keeping things DRY by getting controller from path
  def controller_name_from_path(path_string)
    path_params = Rails.application.routes.recognize_path main_app.send(path_string)
    return path_params[:controller] if path_params.has_key?(:controller)
  end

end
