module FullBodyEvaluationsHelper

  def render_form(form)
    form.fields.collect do |field_name, field|
      render "forms/#{field.type}", field: field
    end.join("\n").html_safe
  end

  def render_total_pdf(form)
    form.fields.collect do |field_name, field|
      if field.type == "select"
        render "forms/radio", field: field
      elsif field.type == "partialdate"
        field.value = nil
        render "forms/number", field: field
      else
        render "forms/#{field.type}", field: field
      end
    end.join("\n").html_safe    
  end

  def render_total_blank_pdf_fb(form)
    form.fields.collect do |field_name, field|
      field.value = nil
      if field.type == "select"
        render "forms/radio", field: field
      elsif field.type == "partialdate"
        render "forms/number", field: field
      else
        render "forms/#{field.type}", field: field
      end
    end.join("\n").html_safe    
  end
  
  def buildExamResponseXml(the_full_body_evaluation_to_use)
#    return '<cld:ExamResponse></cld:ExamResponse>'
    # create a new ExamResponse object from Exam Response model (includes xmlns definitions internally)
    # add the items to the Exam Response object
    # return the string representing the XML from the ExamResponse object.
    
    # Per the VBMS eDocument Service Version 4.0 Service Description Document (the Usage Guide), Section 3.1, General Rules:
    # - Multiple fact elements in a single document (ExamResponse tag), but each have to be of the same type
    # - Each fact element has EXACTLY one diagnosis element
    # - If a secondary diagnosis is REQUIRED, the primary diagnosis should be the first diagnosis.
    
    # this means that we:
    # - generate one ExamResponse tag (document) for EACH kind of fact block
    # - - add all diagnoses and diagnosis modifiers to the fact block to which they belong
    # - - add all symptoms to the fact block to which they belong
    # - - generate a common-data section
    # - - generate an attached-documents section
    # - cycle through the fact blocks
    # - - build an ExamResponse object containing
    # - - - common-data section (with the ExamFact Document Description added)
    # - - - fact block sections for this fact block
    # - - - attached-document section
    
#cs    the_exam_response_generation_framework = ExamResponseGenerationFramework.new(VbmsRFactGroup.all)
#cs    the_form = the_full_body_evaluation_to_use.html_document_fragment
#cs    process(the_form,the_exam_response_generation_framework)  
#cs    the_exam_response_generation_framework.consolidates_its_elements
#cs    return the_exam_response_generation_framework.xml_string(the_full_body_evaluation_to_use)
#binding.pry #cs
    return self.loaded_exam_response_generation_framework(the_full_body_evaluation_to_use).xml_string(the_full_body_evaluation_to_use)
  end
  
  def the_exam_responses_for(the_full_body_evaluation_to_use)
    return self.loaded_exam_response_generation_framework(the_full_body_evaluation_to_use).exam_response_xml_documents(the_full_body_evaluation_to_use)
  end
  
  def loaded_exam_response_generation_framework(the_full_body_evaluation_to_use)
    the_exam_response_generation_framework = ExamResponseGenerationFramework.new(VbmsRFactGroup.all)
    the_form = the_full_body_evaluation_to_use.html_document_fragment
    process(the_form,the_exam_response_generation_framework)  
    the_exam_response_generation_framework.consolidates_its_elements
    return the_exam_response_generation_framework
  end

  def process(the_node, the_framework)
    the_node.element_children.each do | the_node_to_process |
      the_node_id =  the_node_to_process['id']
      if( (not the_node_id.nil?) && the_user_has_selected(the_node_to_process) &&
#      if( (not the_node_id.nil?) &&
          (the_node_id.starts_with?('symptom-') || the_node_id.starts_with?('diagnosis-') || the_node_id.starts_with?('diagnosis_modifier-') || the_node_id.starts_with?('question-') || the_node_id.starts_with?('question_modifier-')) )
#binding.pry #cs
        the_framework.accepts(the_node_to_process)
      end
      process(the_node_to_process, the_framework)
    end
  end
  
#  def the_user_has_selected( the_field_to_check )
#    the_field_type = the_field_to_check['type']
#    case the_field_type
#      when 'checkbox'
#        return( the_field_to_check['checked'] == 'checked' )
#      when 'radio'
##binding.pry #cs
#        return( the_field_to_check['checked'] == 'checked' )
#      else
#        return false
#    end
#  end

  def the_user_has_selected( the_field_to_check )
    case the_field_to_check.name
      when 'input'
        the_field_type = the_field_to_check['type']
        case the_field_type
          when 'checkbox'
            return( the_field_to_check['checked'] == 'checked' )
          when 'radio'
#binding.pry #cs
            return( the_field_to_check['checked'] == 'checked' )
          else
            return false
        end
      when 'select'
#binding.pry #cs
        the_field_to_check.children.each do |the_option_to_check|
#          if( the_option_to_check['selected'] == 'selected' )
          if( the_option_to_check['selected'] == 'selected' && the_option_to_check['value'] != "" )
#binding.pry #cs
            return true
          end
        end
#binding.pry #cs
        return false
#      when 'option'
#binding.pry #cs
#        return ( the_field_to_check['selected'] == 'selected' )
      else
        return false
    end 
  end

  def render_form_xml(the_full_body_evaluation_to_use)
    render "full_body_evaluations/exam_response/exam_response_document", the_string: buildExamResponseXml(the_full_body_evaluation_to_use)
  end
  
  def render_form_blank_pdf(form)
    form.children.collect do | the_node_to_process |
      the_node_id =  the_node_to_process['id']
      the_result = ''
      if the_node_id.present?    
        if the_node_id.starts_with?('inner_container-major_system') 
          the_result = render "full_body_evaluations/rawstring_show", the_string: the_node_to_process.previous.previous.children.text           # make all of these their own 'render "full_body_evaluation/#{the_node_id}_show"' calls (collapses)
        elsif the_node_id.starts_with?('inner_container-minor_system') 
          the_result = render "full_body_evaluations/rawstring_show", the_string: the_node_to_process.previous.previous.children.text + ':'
        elsif the_node_id.starts_with?('symptom-') && the_node_id.ends_with?('-yes')
          if the_node_to_process.parent == the_node_to_process.parent.parent.first_element_child 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'Symptoms:'
          end
          question = the_node_to_process.parent.text
          question.sub!("\nYes No ", "")
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + question
        elsif the_node_id.starts_with?('diagnosis-') && the_node_id.ends_with?('-yes')
          if the_node_to_process.parent == the_node_to_process.parent.parent.first_element_child 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'Diagnoses:'
          end        
          question = the_node_to_process.parent.text.split("\n")[1]
          question.sub!("Yes No  -", "")
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ● ' + question
        elsif the_node_id.starts_with?('diagnosis_modifier-')
          if the_node_to_process.to_s.include?("select")
              question = the_node_to_process.parent.text.split("\n")[1].gsub('-- select an option --', '')
              the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + question              
              the_node_to_process.children.each do |c|
                the_result += render "full_body_evaluations/rawstring_show", the_string: '&#10;&#13;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + c.text
              end
          elsif the_node_to_process.name == "textarea"
            label = the_node_to_process.parent.elements[0].text
            label.sub!("No  - ", "")
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + label
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " [ Text Box ] "
          else 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' - ' + the_node_to_process.attr('value') 
          end     
        elsif the_node_id.starts_with?('question-') #&& the_node_id.ends_with?('-yes')
          if the_node_to_process.parent == the_node_to_process.parent.parent.first_element_child && the_node_id.ends_with?('-yes')
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'General Questions:'
          end        
          question = the_node_to_process.parent.text
          question = question.match(/.*?\n.*\n/)[0]
          question.sub!("\nYes No  -", "")
          the_node_id.include?("-yes") ? answer = "Yes" : answer = "No"   
          if the_node_id.ends_with?('-yes')
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ● ' + question
          end
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▸ ' + answer          
        elsif the_node_id.starts_with?('question_modifier-')
          if the_node_to_process.to_s.include?("select")
              question = the_node_to_process.parent.text.split("\n")[1].gsub('-- select an option --', '')
              the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + question
              the_node_to_process.elements.each do |e|
                if !e.text.downcase.include?("select an option") 
                  the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ◦ " + e.text
                end
              end
          elsif the_node_to_process.name == "textarea"
            label = the_node_to_process.parent.elements[0].text
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + label
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " [ Text Box ] "
          else 
            if the_node_to_process.previous.previous.previous.text.present?
              the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▪ ' + the_node_to_process.previous.previous.previous.text             
            end
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ◦ ' + the_node_to_process.attr('value')             
          end                  
        end
      end
      the_result + render_form_blank_pdf(the_node_to_process)      
    end.join("\n").html_safe
  end 

  
  def has_answered_diagnoses_symptoms_questions?(parent_node)
    parent_node.children.collect do |child_node|
      if child_node['id'].present? && (child_node['id'].starts_with?('diagnosis-') || child_node['id'].starts_with?('symptom-')) && child_node.to_s.include?("checked")
        return true
      else
        has_answered_diagnoses_symptoms_questions? (child_node)
      end
    end
  end  
  
  def is_first_checked_child?(node)
    first_checked_node = nil
    node.parent.parent.elements.each do |e|
      if e.to_s.include?("checked")
        first_checked_node = e
        break
      end
    end
    node.parent == first_checked_node ? true : false
  end
  
  def render_form_show_fb(form)
    form.children.collect do | the_node_to_process |
      the_node_id =  the_node_to_process['id']
      the_result = ''
      if the_node_id.present?    
        if the_node_id.starts_with?('inner_container-major_system') && has_answered_diagnoses_symptoms_questions?(the_node_to_process).to_s.include?("true")
          the_result = render "full_body_evaluations/rawstring_show", the_string: the_node_to_process.previous.previous.children.text           # make all of these their own 'render "full_body_evaluation/#{the_node_id}_show"' calls (collapses)
        elsif the_node_id.starts_with?('inner_container-minor_system') && has_answered_diagnoses_symptoms_questions?(the_node_to_process).to_s.include?("true")
          the_result = render "full_body_evaluations/rawstring_show", the_string: the_node_to_process.previous.previous.children.text + ":"
        elsif the_node_id.starts_with?('symptom-') && the_node_to_process.to_s.include?("checked")
          if is_first_checked_child?(the_node_to_process) 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'Symptoms:'
          end        
          question = the_node_to_process.parent.text
          question.sub!("\nYes No ", "")
          the_node_id.include?("-yes") ? answer = "Yes" : answer = "No"
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + question
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + answer
        elsif the_node_id.starts_with?('diagnosis-') && the_node_to_process.to_s.include?("checked")
          if is_first_checked_child?(the_node_to_process) 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'Diagnoses:'
          end          
          question = the_node_to_process.parent.text.split("\n")[1]
          question.sub!("Yes No  -", "")
          the_node_id.include?("-yes") ? answer = "Yes" : answer = "No"
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ● ' + question
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▸ ' + answer
        elsif( the_node_id.starts_with?( 'diagnosis_modifier-' ) )
          if the_node_to_process.to_s.include?("checked")
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' - ' + the_node_to_process.attr('value') 
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + "Checked"
          elsif the_node_to_process.to_s.include?("selected")
            first = the_node_to_process.children.first
            if !(first.attr('selected') == "selected" && first.attr('value') == "")  || the_node_to_process.attr('multiple').present?
              question = the_node_to_process.parent.text.split("\n")[1].gsub('-- select an option --', '')
              answer = ''
              the_node_to_process.children.each do |c|
                c.attr('selected').present? ? answer += c.text + "\n"  : false
              end
              the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " - " + question
              the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + answer.html_safe
            end
          elsif the_node_to_process.name == "textarea"
            label = the_node_to_process.parent.elements[0].text
            label.sub!("No  - ", "")
            text = the_node_to_process.attributes['value'].value
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + label
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + text 
          end
        elsif the_node_id.starts_with?('question-') && the_node_to_process.to_s.include?("checked")           
          if is_first_checked_child?(the_node_to_process) 
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + 'General Questions:'
          end                      
          question = the_node_to_process.parent.text #.split("\n")[1]
          question = question.match(/.*?\n.*\n/)[0]          
          question.sub!("Yes No  -", "")
          the_node_id.include?("-yes") ? answer = "Yes" : answer = "No"
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ● ' + question
          the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▸ ' + answer
        elsif( the_node_id.starts_with?( 'question_modifier-' ) )
          if the_node_to_process.to_s.include?("checked")
            if the_node_to_process.previous.previous.previous.text.present?
              the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▪ ' + the_node_to_process.previous.previous.previous.text                         
            else 
              the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ▪ ' + 'The following item is checked:'             
            end            
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ◦ ' + the_node_to_process.attr('value')                         
          elsif the_node_to_process.to_s.include?("selected")
            first = the_node_to_process.children.first
            if !(first.attr('selected') == "selected" && first.attr('value') == "")  || the_node_to_process.attr('multiple').present?
              question = the_node_to_process.parent.text.split("\n")[1].gsub('-- select an option --', '')
              answer = ''
              the_node_to_process.elements.each do |e|
                e.attr('selected').present? ? answer += e.text + "\n"  : false
              end
              the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + question
              the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + ' ◦ ' + answer.html_safe
            end
          elsif the_node_to_process.name == "textarea"
            label = the_node_to_process.parent.elements[0].text
            text = the_node_to_process.attributes['value'].value
            the_result = render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + " ▪ " + label
            the_result += render "full_body_evaluations/rawstring_show", the_string: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.html_safe + text 
          end          
        end
      end
      the_result + render_form_show_fb(the_node_to_process)      
    end.join("\n").html_safe


#cs    form.fields.collect do |field_name, field|
#cs      if field.visible?
#cs        if field.type == "checkbox"
#cs          render "forms/#{field.type}_show", field: field unless field.value.nil?
#cs        else
#cs          render "forms/#{field.type}_show", field: field
#cs        end
#cs      end
#cs    end.join("\n").html_safe
  end
  
  def render_form_show_txt_fb(form)
#    form.fields.collect do |field_name, field|
    form.children.collect do | the_node_to_process |
#binding.pry #cs
      the_node_id =  the_node_to_process['id']
      the_result = ''
      if( not the_node_id.nil? )
        if( the_node_id.starts_with?( 'visibility-major_system-' ) )
          the_result = the_node_id                                        # make all of these their own 'the_string_for...(the_node_to_process)'
#binding.pry #cs
        elsif( the_node_id.starts_with?( 'visibility-minor_system-' ) )
          the_result = '- ' + the_node_id
        elsif( the_node_id.starts_with?( 'symptom-' ) )
          the_result = '- - ' + the_node_id
        elsif( the_node_id.starts_with?( 'diagnosis-' ) )
          the_result = '- - ' + the_node_id
        elsif( the_node_id.starts_with?( 'diagnosis_modifier-' ) )
          the_result = '- - + ' + the_node_id
        end
      end
#binding.pry #cs
      p the_result + render_form_show_txt_fb(the_node_to_process)
#binding.pry #cs
    end.join("\n").html_safe
#      if field.visible?
#        if field.type == "partialdate"
#          partialdate_to_txt(field)
#        elsif field.type == "checkbox"
#          "#{field.label}\n  #{field.value}" unless field.value.nil?
#        else
#          "#{field.label}\n  #{field.value}"
#        end
#      end
#    end.join("\n").html_safe
  end
  
  def partialdate_to_txt(field)
    result = "#{field.label}\n  #{field.day} #{months[field.month]} #{field.year}"
    result += " Unknown " if field.unknown
    result += " Estimate " if field.estimate
    result.squish
  end

  def conditional_helper(field)
    conditional = field.conditional_on
    return {} if conditional.nil?

    if conditional.is_a?(String)
      return {"data-display-conditional-on-boolean-field" => conditional}
    elsif conditional.is_a?(Hash)
      key = field.conditional_on.keys.first
      return {
        "data-display-conditional-on-textual-field" => conditional[key]['field'],
        "data-display-conditional-on-values" => Array(conditional[key]['value'] || conditional[key]['values'])
      }
    end
  end

  def months
    {
      "1"  => "January",
      "2"  => "February",
      "3"  => "March",
      "4"  => "April",
      "5"  => "May",
      "6"  => "June",
      "7"  => "July",
      "8"  => "August",
      "9"  => "September",
      "10" => "October",
      "11" => "November",
      "12" => "December"
    }
  end
end

class Array
  def append_none
    self.push(['--none--', -1])
  end
end
