module ExaminationsHelper
	include DashboardsHelper

	def submission_buttons(examination)
		name = examination.name
		code = examination.code
		statuses = ['Ready to be Scheduled','Pending','Scheduled']
		link = ""

		if statuses.exclude?(name) && code != ExaminationStateHelper::RESCHEDULE
			link = link_to('Ready for Review', edit_examination_path(examination, status: 'completed'), class: 'button')
   	end

   	if name == "Reviewed"
    	link = link_to 'Submit', edit_examination_path(examination, status: "reviewed"), class: "button"
    end

    if name == "Reviewed" && examination.already_submitted?
      link = link_to 'Resubmit', edit_examination_path(examination, status: "reviewed"), class: "button"
    end

   	link
  end
end
