module EvaluationsHelper

  def render_form(form)
    form.fields.collect do |field_name, field|
      render "forms/#{field.type}", field: field
    end.join("\n").html_safe
  end

  def render_total_pdf(form)
    form.fields.collect do |field_name, field|
      if field.type == "select"
        render "forms/radio", field: field
      elsif field.type == "partialdate"
        field.value = nil
        render "forms/number", field: field
      else
        render "forms/#{field.type}", field: field
      end
    end.join("\n").html_safe    
  end

  def render_total_blank_pdf(form)
    form.fields.collect do |field_name, field|
      field.value = nil
      if field.type == "select"
        render "forms/radio", field: field
      elsif field.type == "partialdate"
        render "forms/number", field: field
      else
        render "forms/#{field.type}", field: field
      end
    end.join("\n").html_safe    
  end
  
  def render_form_show(form)
    form.fields.collect do |field_name, field|
      if field.visible?
        if field.type == "checkbox"
          render "forms/#{field.type}_show", field: field unless field.value.nil?
        else
          render "forms/#{field.type}_show", field: field
        end
      end
    end.join("\n").html_safe
  end
  
  def render_form_show_txt(form)
    form.fields.collect do |field_name, field|
      if field.visible?
        if field.type == "partialdate"
          partialdate_to_txt(field)
        elsif field.type == "checkbox"
          "#{field.label}\n  #{field.value}" unless field.value.nil?
        else
          "#{field.label}\n  #{field.value}"
        end
      end
    end.join("\n").html_safe
  end
  
  def partialdate_to_txt(field)
    result = "#{field.label}\n  #{field.day} #{months[field.month]} #{field.year}"
    result += " Unknown " if field.unknown
    result += " Estimate " if field.estimate
    result.squish
  end

  def conditional_helper(field)
    conditional = field.conditional_on
    return {} if conditional.nil?

    if conditional.is_a?(String)
      return {"data-display-conditional-on-boolean-field" => conditional}
    elsif conditional.is_a?(Hash)
      key = field.conditional_on.keys.first
      return {
        "data-display-conditional-on-textual-field" => conditional[key]['field'],
        "data-display-conditional-on-values" => Array(conditional[key]['value'] || conditional[key]['values'])
      }
    end
  end

  def months
    {
      "1"  => "January",
      "2"  => "February",
      "3"  => "March",
      "4"  => "April",
      "5"  => "May",
      "6"  => "June",
      "7"  => "July",
      "8"  => "August",
      "9"  => "September",
      "10" => "October",
      "11" => "November",
      "12" => "December"
    }
  end

  def user_assignee_examiner_error
    if (flash[:alert] == "Error adding evaluation to contention: User Assignee examiner can't be blank")
      return "form_with_errors"
    else
      return ""
    end
  end

  def eval_spec_error
    if (flash[:alert] == "Error adding evaluation to contention: Evaluation spec can't be blank")
      return "form_with_errors"
    else
      return ""
    end
  end
end

class Array
  def append_none
    self.push(['--none--', -1])
  end
end
