module DashboardsHelper

  def get_exam_requester examination
    er = ExamRequest.find(examination.exam_request_id)
    er.exam_requester rescue nil
  end

  def iterate_through_schedules(app)
    app.examination_schedules.inject("") { |str, app|
      str + exam_time_format(app.exam_date_time) + "</br>"
    }.html_safe
  end

  def iterate_through_exams(app)
    app.examination_ids.inject(""){ |str, id|
      str + link_to('Exam', edit_examination_path(id)) + "</br>"
    }.html_safe
  end

	def exam_time_format(t)
		t.kind_of?(DateTime) || t.kind_of?(Time) ? t.strftime("%d-%m-%Y %H:%M") : ''
	end

  def requested_site_name alert
    alert.site.present? ? Site.find(alert.site.to_i).name : "Site not specified"
  end

  def requester_name alert
    User.find(alert.requested_by.to_i).name
  end

  def days_in_state(exam)
    if exam.examination_state_start_date.present?
      (DateTime.current.to_date - exam.examination_state_start_date.to_date).to_i
    else
      nil
    end
  end

  def request_link alert
    case alert.notification_type
    when Alert::REQUEST_SITE_TYPE
      site_request_site_user_path(site_id: alert.site, id: alert.requested_by.to_i)
    when Alert::REQUEST_CUI_TYPE
      access_request_user_path(id: alert.requested_by.to_i)
    else
      "#"
    end
  end
end
