module ClarificationHelper
  include RequestObjectHelper

  def processClarificationResponseEvent(notificationDoc)
   ActiveRecord::Base.transaction do
    clarificationResponseEvent = XmlHelper.getDoc(notificationDoc, "ClarificationResponseEvent")

    if (validClarificationResponseEvent(clarificationResponseEvent))
      previousEventId = clarificationResponseEvent['previousEvent']
      clarificationDetailRecord = ClarificationDetail.where("event_id = ? and clarification_type='1'", previousEventId )

      if (clarificationDetailRecord.count == 0)
        raise Exception, "Invalid previousEventId"
      end

      clarifiedContentionsDoc = XmlHelper.getDoc(clarificationResponseEvent, "ClarifiedContentions")
      clarifiedContentions = XmlHelper.getAll(clarifiedContentionsDoc, "ClarifiedContention")

      if (clarifiedContentions == nil or clarifiedContentions.count == 0)
        raise Exception, "Invalid Clarification Response"
      end
      claimId = ""
      clarifiedContentions.each do |clarifiedContentionDoc|
        examRelatedContentionId = clarifiedContentionDoc['examRelatedContentionId']
        contention = Contention.find_by_exam_related_contention_id(examRelatedContentionId)
        if (contention == nil)
          raise Exception, "Invalid examRelatedContentionId"
        end

        claimId = contention.claim_id
        clarificationText = XmlHelper.getDoc(clarifiedContentionDoc, "ClarificationText").text

        clarificationTypeResponse = ClarificationType.find_by_code("RESPONSE")
        clarificationDetail = ClarificationDetail.create(contention_id: contention.id, event_id: previousEventId, text: clarificationText, clarification_type: clarificationTypeResponse.id)
        clarificationDetail.save
      end
      addClarificationResponseEventToRequestObject(clarificationResponseEvent, claimId)
    else
      raise Exception, "Invalid ClarificationResponse"
    end
   end
  end

  def validClarificationResponseEvent(clarificationResponseEvent)
    return true
  end
 
  def buildAndSendClarificationRequestEvent(user, examRequestIdentifier, selectedContentionIds, clarificationRequest)
    exam_request = ExamRequest.find_by_identifier(examRequestIdentifier)

    clarificationRequestEvent = ClarificationRequestEvent.new
    eventId = clarificationRequestEvent.build_notification(exam_request.claim_id, exam_request.site_id, user, clarificationRequest)
    VlerDASJob.sendNotification(clarificationRequestEvent, eventId, exam_request.claim_id, "Clarification Request Event Notification")

    addClarificationRequestEventToRequestObject(clarificationRequestEvent, exam_request.claim_id)

    #create ExamHistory entry
    addExamRequestHistory(selectedContentionIds, exam_request)
    
    return eventId 
  end

  private

  def addExamRequestHistory(selectedContentionIds, examRequest)
    notes = current_user.first_name + " " + current_user.last_name + " requested clarification for"
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      notes = notes + separator + contention.contention_details[0].name
    end
    @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @exam_request_history.save
  end
end
