module ApplicationHelper


  def assigner_for(contention)
    return "" if contention.assigner.nil?
    if contention.assigner == current_user
      return "You"
    elsif contention.assigner && contention.assigner.last_name
      return "Dr. #{contention.assigner.last_name}"
    else
      return "Unassigned"
    end
  end


  def referral_status_count(status)
    ReferralStatus.where('lower(name) = ?', status.downcase).first.referrals.count
  end


  # Generates a html select tag from a model name.
  # Option values are record ids, display value is record title.
  # Returns an html string for a select tag, with all option tags.
  # model_name should be a class with static text values.
  def get_options_from_model(model_name)
    html = "".html_safe
    html.safe_concat "<select name='" + model_name.name.underscore + "'>"

    records = model_name.all.order(:sequence)
    records.each do |rec|
      html.safe_concat "<option value=" + rec.id.to_s + ">" + rec.title + "</option>"
    end

    html.safe_concat "</select>"

    html
  end


  def yes_no(val)
    val ? 'Yes' : 'No'
  end

  # Returns a ActiveSupport::TimeWithZone object set to UTC time,
  # with the value equal to the time_string passed in, in the user's
  # time zone as set in user preferences.
  def datetime_string_to_time_with_zone(time_string, time_format, user)
    unless time_string.blank?
      user_timezone = user.user_preference.time_zone
      parsed_dt = DateTime.strptime(time_string, time_format)
      return ActiveSupport::TimeZone[user_timezone].tzinfo.local_to_utc(parsed_dt)
    end
  end


  # Formats datetime passed in as calendar day, as per user's timezone preference
  # Accepted date format parameters:
  # :dashes => display as "month-day-year" (default)
  # :text => display as "MonthAsText day, year"
  # :slashes => display as "month/day/year"
  def formatted_date_simple(datetime, user, format = :dashes)
    time_zone = user.user_preference.time_zone
    datetime = datetime.in_time_zone time_zone
    if datetime.present?
      case format
      when :dashes
        datetime.strftime('%m-%d-%Y')
      when :text
        datetime.strftime('%B %e, %Y')
      when :slashes
        datetime.strftime('%m/%d/%Y')
      end
    end
  end


  # Formats datetime passed in as date and time, as per user's timezone preference
  # All datetimes are formatted as:
  # "MonthAsText day, year at hour:minute AM/PM", with timezone appended to end
  # if with_zone_displayed is true
  def formatted_datetime(datetime, user, with_zone_displayed = true)
    time_zone = user.user_preference.time_zone
    datetime = datetime.in_time_zone time_zone
    if datetime.present?
      datetime.strftime("%B %e, %Y at %l:%M %p#{' %Z' if with_zone_displayed}")
    end
  end


  # Prints address in standardized format.  address_opts is a hash that requires
  # the following keys: [:address, :city, :state, :zip]
  def format_address(address_opts)
    if [:address, :city, :state, :zip].all? {|field| address_opts[field].present? }
      if address_opts[:address].is_a? Array
        formatted_address = address_opts[:address].join(' ')
      else
        formatted_address = address_opts[:address]
      end
      "#{formatted_address}, #{address_opts[:city]}, #{address_opts[:state]} #{address_opts[:zip]}"
    end
  end


  def health_insurace_selected?(consultation, option)
    consultation.veteran.other_health_insurance.title.eql?(option)
  end


  def urgent_priority_selected?(consultation, option)
    consultation.content['urgent_priority'].eql?(option)
  end


  def field_class(resource, attribute)
    if resource.errors[attribute].present? || resource.errors[:base].present?
      return "form_with_errors".html_safe
    else
      return "".html_safe
    end
  end


  def flash_alert_class(flash_alert)
    flash_alert.present? ? "form_with_errors" : ""
  end

  def get_contention_names(exam)
    exam.contentions.inject("") { |str, con| str + con.contention_details.first.name.to_s + "</br>" }.html_safe
  end

end # module ApplicationHelper
