

class StageExamRequestsController < ApplicationController
  before_action :set_stage_exam_request, only: [:edit, :update, :destroy]

  XML_FILENAME = "ExamRequestTemplate.xml".freeze
  XLS_FILENAME = "CUI_Template_Stage_Exam_Requests_Contentions_data.xls".freeze


  XML_TEMPLATE_PATH = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', XML_FILENAME).freeze
  XLS_TEMPLATE_PATH = File.join(Rails.root.to_s, 'public', XLS_FILENAME).freeze


  file = File.open(XML_TEMPLATE_PATH)
  XML_EXAM_REQUEST_TEMPLATE = file.read


  # GET /stage_exam_requests
  # GET /stage_exam_requests.json
  def index

  end

  # GET /stage_exam_requests/1
  # GET /stage_exam_requests/1.json
  def show
  end

  # GET /stage_exam_requests/new
  def new

  end

  # GET /stage_exam_requests/1/edit
  def edit
  end

  # POST /stage_exam_requests
  # POST /stage_exam_requests.json
  def create
    if uploaded_io = params[:batch_exam_requests][:excel_file]
      suffix = Time.now.strftime('%Y%m%d%s')
      File.open(Rails.root.join('public', 'uploads','StageExamRequests', uploaded_io.original_filename), 'wb') do |file|
        file.write(uploaded_io.read)
        AddExamRequestFromXls.perform_now(uploaded_io.original_filename)
        flash.now[:notice] = "Exam Request uploaded!"
        render 'new'

      end


    else
      er_contents = XML_EXAM_REQUEST_TEMPLATE.clone
      er_contents.gsub! '###FIRST_NAME###',  params[:single_exam_request][:first_name]
      er_contents.gsub! '###LAST_NAME###',   params[:single_exam_request][:last_name]
      er_contents.gsub! '###FILE_NUMBER###', params[:single_exam_request][:file_number]
      er_contents.gsub! '###CLAIM_ID###',    params[:single_exam_request][:claim_id]
      er_contents.gsub! '###SITE###',        params[:single_exam_request][:site]

      #post the data
      if PostXmlToEndpoint.set(wait: 1.seconds).perform_later(contents)
        flash.now[:notice] = "Exam Request staged!"
        render 'new'
      else
        flash.now[:alert] = "Exam Request could not be staged!"
        render 'new'
      end
      er_contents = ""
    end
  end

  def download_excel_template
      send_file(
        XLS_TEMPLATE_PATH,
        filename: "StageNewExamRequests.xls",
        disposition: "attachment",
        type: "application/xls",
        x_sendfile: true
      ) and return
  end

  # PATCH/PUT /stage_exam_requests/1
  # PATCH/PUT /stage_exam_requests/1.json
  def update
    respond_to do |format|
      if @stage_exam_request.update(stage_exam_request_params)
        format.html { redirect_to @stage_exam_request, notice: 'Stage exam request was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @stage_exam_request.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /stage_exam_requests/1
  # DELETE /stage_exam_requests/1.json
  def destroy
    @stage_exam_request.destroy
    respond_to do |format|
      format.html { redirect_to stage_exam_requests_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_stage_exam_request
      @stage_exam_request = StageExamRequest.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def stage_exam_request_params
      params[:stage_exam_request]
    end
end
