class SearchesController < ApplicationController
	def appointments
		if params[:commit].present? && !fields_present?(params)
			flash[:alert] = "Please specify the patient full name, and an end date that is later than the start date."
			redirect_to searches_appointments_path
		end

		@apps = Claim.appointment_search
		@apps = @apps.dates(params[:start_date], params[:end_date]) if params[:start_date].present? && params[:end_date].present?
		@apps = @apps.p_name(params[:p_name]) if params[:p_name].present?
		@apps = @apps.patient_id_search(params[:patient_id_search]) if params[:patient_id_search].present?
	end

	private
	def fields_present? params
		params[:p_name].present? &&
		params[:end_date].present? &&
		params[:start_date].present? &&
		Date.strptime(params[:end_date], "%m/%d/%Y") >= Date.strptime(params[:start_date], "%m/%d/%Y")
	end
end
