class ScheduleExaminationsController < BaseExaminationsController
  before_action :set_schedule_examination, only: [:show, :edit, :update, :destroy]

  # GET /schedule_examinations
  # GET /schedule_examinations.json
  def index
    
    @contention_data = get_contention_data

    puts @contention_data
    @claim_contentions = Hash.new

    if @contention_data != nil
      @contention_data.each do |key, value|
        #binding.pry
        @claim_contentions[key["first_name"] + " " + key["last_name"] + " (" + key["file_number"] + ") - " + key["name"]] = key["id"]
       end
     end
     
     @all_sites = Site.all
     if @all_sites != nil
       @sites = @all_sites.map{ |s| [s.name, s.id] }
     end

     @all_clinicians = User.get_all_clinicians
      @clinicians = Hash.new
      if @all_clinicians != nil
        @all_clinicians.each do |key, value|
          @clinicians[key["first_name"] + " " + key["last_name"]] = key["id"]
        end
      end
 
     if current_user.is_developer?
       @exam_request_processor = ExamRequestProcessor.new
     else
       redirect_to root_path, alert: "You are not authorised to create an examination."
     end   
  end

  # GET /schedule_examinations/1
  # GET /schedule_examinations/1.json
  def show
  end

  # GET /schedule_examinations/new
  def new
    
  end

  # GET /schedule_examinations/1/edit
  def edit
  end

  # POST /schedule_examinations
  # POST /schedule_examinations.json
  def create
 #   @schedule_examination = ScheduleExamination.new(schedule_examination_params)
 #
 #   respond_to do |format|
 #     if @schedule_examination.save
 #       format.html { redirect_to @schedule_examination, notice: 'Schedule examination was successfully created.' }
 #       format.json { render action: 'show', status: :created, location: @schedule_examination }
 #     else
 #       format.html { render action: 'new' }
 #       format.json { render json: @schedule_examination.errors, status: :unprocessable_entity }
 #     end
 #   end
 
    @examinationState = ExaminationState.find_by_code "SCHEDULED"
    @examination = Examination.new(title: "Scheduled Test", contention_id: params[:contention_id], site_id: params[:site_id], examination_state_id: @examinationState.id, clinician: params[:clinician_id])
    @examination.examination_state_start_date = DateTime.current

    examDate = params[:examination_date]
    @examination.exam_date =DateTime.strptime(examDate, "%m/%d/%Y")

    @examination.save

    flash[:notice] = "Scheduled Examination has been successfully created."
    redirect_to schedule_examinations_path

    #@schedule_examination = ScheduleExamination.new()

    #respond_to do |format|
    #    format.html { redirect_to index, notice: 'Scheduled examination was successfully created.' }
    #    # format.json { render action: 'show', status: :created, location: @schedule_examination }
    #  else
    #    format.html { render action: 'new' }
    #    # format.json { render json: @schedule_examination.errors, status: :unprocessable_entity }
    #  end
    #end
  end

  # PATCH/PUT /schedule_examinations/1
  # PATCH/PUT /schedule_examinations/1.json
  def update
    respond_to do |format|
      if @schedule_examination.update(schedule_examination_params)
        format.html { redirect_to @schedule_examination, notice: 'Schedule examination was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @schedule_examination.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /schedule_examinations/1
  # DELETE /schedule_examinations/1.json
  def destroy
    @schedule_examination.destroy
    respond_to do |format|
      format.html { redirect_to schedule_examinations_url }
      format.json { head :no_content }
    end
  end

  private

    # Use callbacks to share common setup or constraints between actions.
    def set_schedule_examination
      @schedule_examination = ScheduleExamination.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def schedule_examination_params
      params[:schedule_examination]
    end
end
