class ReportsController < ApplicationController
  include InsufficientExamReportGenerator
  check_authorization
  authorize_resource class: false

	def insufficient_exam_report
    	if params[:start_date].present? && params[:end_date].present? && params[:format].present?
            start_date = Date.strptime(params[:start_date], '%m/%d/%Y')
    		end_date = Date.strptime(params[:end_date], '%m/%d/%Y')

	    	con_array = []

            columns = [:exam_date, :patient_name, :patient_ssn, :vbms_claim_id, :benefit_type, :special_issues, :contention_description, :previous_contention_exams, :rework_reason_list, :rework_reason_free_text_list]
            contentions = Contention.where(insufficient: true, :created_at => start_date.beginning_of_day..end_date.end_of_day)
            contentions.each do |cont|
                con_hash = {}
                columns.each do |col|
                    con_hash[col] = cont.send(col)
                end
                con_array << con_hash
            end
    		respond_to do |f|
        		f.csv  { send_data generate_insufficient_exam_report_csv(con_array), filename: "insufficient_exam_report-#{Date.today}.csv" }
                f.text { send_data generate_insufficient_exam_report(con_array, start_date, end_date), filename: "insufficient_exam_report-#{Date.today}.txt" }
    		end
    	elsif request.post?
          flash.now[:alert] = "Please provide a valid date range and select a report type (CSV or Plain text)."
        end
	end


	def pending_exam
		@exam_requests = ExamRequest.where(nil)
		attributes = [:patient_name, :patient_ssn, :phone_number, :email, :file_number, :created_at, :elapsed_days, :benefit_type, :special_issues, :identifier ]
        column_titles = %w( Veteran\ Name SSN Cell\ Number E-mail Claim\ Number Request\ Date Elapsed\ Days Claim\ Type Special\ Considerations Exam\ Request)

		filtering_params(params).each do |key, value|
    		@exam_requests = @exam_requests.public_send(key, value) if value.present?
  	    end

		respond_to do |format|
			format.html
			format.text { send_data render_to_string(template: "reports/plain_text").gsub(/[\r\n]+/, "\r\n"),
													 filename: "pending_exam_report-#{Date.today}.txt" }
			format.csv { send_data ReportCsv.generate(@exam_requests, attributes, column_titles) }
		end
	end


	def exam_requests_by_date
    	attributes = [:request_date, :patient_name, :patient_ssn, :request_status_name, :benefit_type, :special_issues, :request_id]
		col_titles = ['Request Date', 'Patient Name', 'SSN', 'Status', 'Claim Type', 'Special Issues', 'Request ID' ]
        if params[:exam_request_start_date].present? && params[:exam_request_end_date].present?
          start_date = Date.strptime(params[:exam_request_start_date], '%m/%d/%Y')
          end_date = Date.strptime(params[:exam_request_end_date], '%m/%d/%Y')
          if start_date > end_date
            flash.now[:alert] = "The end date must be after the start date"
          else
            @exam_requests = ExamRequest.where(request_date: start_date.beginning_of_day .. end_date.end_of_day)
            flash.now[:notice] = "The following Examination Requests have been retrieved for the given date range:"
          end
        else
          flash.now[:alert] = "Please enter a valid date range for Examination Requests" if params[:commit].present?
        end
		respond_to do |format|
			format.html
			format.text { send_data render_to_string(template: "reports/exam_requests_by_date_plain_text").gsub(/[\n]+/, "\r\n"),
													 filename: "exam_requests_by_date_report-#{Date.today}.txt" }
			format.csv { send_data ReportCsv.generate(@exam_requests, attributes, col_titles) }
		end
	end


	def exam_request_status_by_date
    	attributes = [:request_date, :patient_name, :patient_ssn, :benefit_type, :request_status_name, :special_issues, :request_id]
		col_titles = ['Request Date', 'Veteran Name', 'SSN', 'Status', 'Benefit Type', 'Special Issues', 'Request ID' ]
        if !params[:exam_request_start_date].nil?
        	params[:request_status].present? ? @exam_req_state = ExamRequestState.find(params[:request_status]) : @exam_req_state = ExamRequestState.all
        	if params[:exam_request_start_date].present? && params[:exam_request_end_date].present?
        		start_date = Date.strptime(params[:exam_request_start_date], '%m/%d/%Y')
            	end_date = Date.strptime(params[:exam_request_end_date], '%m/%d/%Y')
            	if start_date >= end_date
            		flash.now[:alert] = "The end date must be after the start date"
            	else
            		@exam_requests = ExamRequest.where(request_date: start_date.beginning_of_day .. end_date.end_of_day,
            										   exam_request_state: @exam_req_state)
            		flash.now[:notice] = "The following Examination Requests have been retrieved for the given date range:"
            	end
            else
            	@exam_requests = ExamRequest.where(exam_request_state: @exam_req_state)
            	flash.now[:notice] = "The following Examination Requests were retrieved for a blank date range"
            end
        end
		respond_to do |format|
			format.html
			format.text { send_data render_to_string(template: "reports/exam_requests_by_date_plain_text"),
													 filename: "exam_requests_by_date_report-#{Date.today}.txt" }
			format.csv { send_data ReportCsv.generate(@exam_requests, attributes, col_titles) }
		end
	end

	private

		def filtering_params(params)
			params.slice(:request_status, :routing_location, :p_name, :elapsed_days)
		end

end
