class RejectionsController < ApplicationController
  check_authorization
  authorize_resource

  before_filter :assign_claim
  before_filter :assign_contention

  def new
    @rejection = @contention.rejections.new
  end

  def create
    @rejection = @contention.rejections.new(rejection_params)
    if @rejection.save
      @contention.unresolve!(current_user)
      flash[:notice] = "Contention has been unsubmitted and user notified."
      redirect_to claims_path
    else
      flash[:alert] = @rejection.errors.full_messages.join(" ")
      render :new
    end
  end

  private

  def assign_contention
    @contention = @claim.contentions.find(params[:contention_id])
    if !@contention.resolved?
      flash[:alert] = "Cannot reject a contention that is not yet resolved"
      redirect_to claims_path
    end
  end

  def rejection_params
    params.require(:rejection).permit(:reason, :contention_id)
  end
end
