class ReferralNotesController < ApplicationController
  before_action :set_referral, only: [:create]
  check_authorization
  authorize_resource

  def create
    @referral_note = @referral.referral_notes.new(referral_note_params)
    @referral_note.user = current_user.name
    respond_to do |format|
      if @referral.save
        format.html do
          flash[:notice] = 'Referral Note was successfully created.'
          redirect_to referral_path(@referral, tabpage: 'notes')
        end
        format.json { render json: @referral, status: :created }
      else
        format.html do
          flash[:alert] = @referral.errors.full_messages.join(" ")
          redirect_to referral_path(@referral, tabpage: 'notes')
        end
        format.json { render json: @referral.errors, status: :unprocessable_entity }
      end
    end
  end

private
  # Use callbacks to share common setup or constraints between actions.
  def set_referral
    @referral = Referral.find(params[:referral_id])
  end

  # Never trust parameters from the scary internet, only allow the white list through.
  def referral_note_params
    params.require(:referral_note).permit(:user, :notes)
  end

end