class ReferralAppointmentsController < ApplicationController
  include ReferralAppointmentsHelper

  before_action :set_referral, only: [:create]
  before_action :set_referral_and_appointment, only: [:add_to_cprs, :update]
  check_authorization
  authorize_resource

  def create
    ra_params_hash = referral_appointment_params.to_h
    ra_params_hash['appointment_time'] = datetime_string_to_time_with_zone(
      ra_params_hash['appointment_time'],
      ReferralAppointment::APPOINTMENT_TIME_FORMAT,
      current_user
    )
    Rails.logger.debug "PARAMS HASH = #{ra_params_hash.inspect}"
    @referral_appointment = @referral.referral_appointments.new(ra_params_hash)
    respond_to do |format|
      if @referral.save
        format.html do
          flash[:notice] = 'Appointment was successfully created.'
          redirect_to referral_path(@referral, tabpage: 'appointments')
        end
        format.json { render json: @referral, status: :created }
      else
        if @referral_appointment.appointment_time.nil?
          @referral.errors.clear
          @referral.errors.add(:base, "Please select a date and time for the appointment.")
        end
        format.html do
          flash[:alert] = @referral.errors.full_messages.join(" ")
          redirect_to referral_path(@referral, tabpage: 'appointments')
        end
        format.json { render json: @referral.errors, status: :unprocessable_entity }
      end
    end
  end

  def update
    request_body = JSON.parse request.body.read
    attributes_hash = {
        "appointment_type" => request_body['appointment_type'], "scheduled_by" => request_body['scheduled_by'], "appointment_time" => request_body['appointment_time']
    }

    if(attributes_hash['appointment_time'])
      attributes_hash['appointment_time'] = datetime_string_to_time_with_zone(  attributes_hash['appointment_time'],
                                                                 ReferralAppointment::APPOINTMENT_TIME_FORMAT,
                                                                 current_user)
    end

    respond_to do |format|
      format.json do
        if @referral_appointment.update_attributes(attributes_hash)
          render json: @referral_appointment, status: :no_content
        else
          render json: @referral_appointment.errors, status: :unprocessable_entity
        end
      end
    end
  end

  def add_to_cprs
    @referral_appointment.added_to_cprs_at = Time.now
    @referral_appointment.added_to_cprs_id = current_user.id
    respond_to do |format|
      if @referral_appointment.save
        format.html do
          notice_text = "Appointment ##{@referral_appointment.appointment_type} was successfully approved."
          redirect_to @referral, notice: notice_text
        end
        format.json do
          result_html = created_in_cprs_datacell_html(@referral_appointment, current_user)
          render json: {created_by: result_html}, status: :ok
        end
      else
        format.html do
          flash[:alert] = @referral_appointment.errors.full_messages.join(" ")
          redirect_to @referral
        end
        format.json { render json: @referral_appointment.errors, status: :unprocessable_entity }
      end
    end
  end

  def destroy
    @appointment = ReferralAppointment.find(params[:id])
    @appointment.destroy
    respond_to do |format|
      format.js {}
    end
  end

private
  # Use callbacks to share common setup or constraints between actions.
  def set_referral
    @referral = Referral.find(params[:referral_id])
  end

  def set_referral_and_appointment
    set_referral
    if params.has_key?(:id)
      @referral_appointment = ReferralAppointment.find(params[:id])
    elsif params.has_key?(:referral_appointment_id)
      @referral_appointment = ReferralAppointment.find(params[:referral_appointment_id])
    else
      raise Exception, "Referral appointment ID not found."
    end
    # check if referral appointment is contained in referral
    unless @referral.referral_appointments.include? @referral_appointment
      raise Exception, "Invalid Referral appointment ##{@referral_appointment.id} for referral ##{@referral.id}."
    end
  end

  # Never trust parameters from the scary internet, only allow the white list through.
  def referral_appointment_params
    params.require(:referral_appointment).permit( :appointment_type,
                                                  :scheduled_by,
                                                  :appointment_time)
  end

end
