class ProvidersController < ApplicationController
  check_authorization
  authorize_resource

  def show
    @provider = Provider.find(params[:id])
    respond_to do |format|
      format.json { render json: @provider,
                           methods: [:phone, :fax, :formatted_address_string, :medical_specialty_names] }
    end
  end

  def find_by_npi
    provider = NpiRegistry.filter(npi: params[:npi])
    unless provider.nil?
      render json: provider, methods: [:phone, :fax], status: :ok
    else
      render json: {error: 'Invalid NPI value.'}, status: :unprocessable_entity
    end
  end

end
