class MajorSystemsController < ApplicationController
  include DataTablePaginator

  before_action :set_major_system, only: [:show, :edit, :update, :destroy, :sort]

  # GET /major_systems
  # GET /major_systems.json
  def index
    major_system_to_fields_func = -> (ms) do
      {
        id:                       ms.id,
        name:                     ms.name.try(:humanize),
        row_label:                ms.label.try(:humanize),
        edit:                     edit_major_system_path(ms),
        destroy:                  major_system_path(ms)
      }
    end
    ordered_major_systems = MajorSystem.all.order('name asc')
    @return_data = datatables_json_for_query_using_func(
      ordered_major_systems, major_system_to_fields_func
    ).to_json
  end

  # GET /major_systems/1
  # GET /major_systems/1.json
  def show
  end

  # GET /major_systems/new
  def new
    @major_system = MajorSystem.new
  end

  # GET /major_systems/1/edit
  def edit
    @major_system = MajorSystem.find(params[:id])
    if params[:delete_minor_system_id].present?
      min = @major_system.minor_systems.find_by_id(params[:delete_minor_system_id])
      @major_system.minor_systems = @major_system.minor_systems.reject{|m| m == min}
      flash.now[:notice] = "Minor System successfully removed."
    end
    set_minor_systems_not_yet_added @major_system

    @generated_html = @major_system.build_html()
  end

  # POST /major_systems
  # POST /major_systems.json
  def create
    @major_system = MajorSystem.new(major_system_params)

    respond_to do |format|
      if @major_system.save
        @major_system.update_attribute(:position, @major_system.id)
        format.html { redirect_to @major_system, notice: 'Major system was successfully created.' }
        format.json { render action: 'show', status: :created, location: @major_system }
      else
        format.html { render action: 'new' }
        format.json { render json: @major_system.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /major_systems/1
  # PATCH/PUT /major_systems/1.json
  def update
    respond_to do |format|
      if @major_system.update(major_system_params)
        if params[:major_system] && params[:major_system][:minor_system_ids]
          params[:major_system][:minor_system_ids].each do |m|
            minor_system = MinorSystem.find_by_id(m)
            if minor_system
              @major_system.minor_systems << minor_system
            end
          end
        end
        @major_system.save
        format.html { redirect_to edit_major_system_path(@major_system), notice: 'Major system successfully updated.' }
        format.json { head :no_content }
      else
        set_minor_systems_not_yet_added @major_system
        @generated_html = @major_system.build_html
        format.html { render action: 'edit' }
        format.json { render json: @major_system.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /major_systems/1
  # DELETE /major_systems/1.json
  def destroy
    @major_system.destroy
    respond_to do |format|
      format.html { redirect_to major_systems_url }
      format.json { head :no_content }
    end
  end

  def sort
    params[:minor_system].each_with_index do |id, index|
      @MajorSystem.minor_systems.where(id: id).update_all({position: index+1})
    end
    render nothing: true
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_major_system
      @major_system = MajorSystem.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def major_system_params
      params.require(:major_system).permit(:name, :label, :position)
    end

    def set_minor_systems_not_yet_added major_system
      @minor_systems_not_yet_added = MinorSystem.all
      major_system.minor_systems.each do |ms|
        @minor_systems_not_yet_added = @minor_systems_not_yet_added.reject{|m| m == ms}
      end
    end
end
