class GeneralQuestionsController < ApplicationController
  include DataTablePaginator
  before_action :set_general_question, only: [:show, :edit, :update, :destroy, :sort]

  # GET /general_questions
  # GET /general_questions.json
  def index
    @general_questions = GeneralQuestion.all
  end

  # GET /general_questions/1
  # GET /general_questions/1.json
  def show
  end

  # GET /general_questions/new
  def new
    @general_question = GeneralQuestion.new
  end

  # GET /general_questions/1/edit
  def edit
    @general_question = GeneralQuestion.find(params[:id])
    if params[:delete_question_modifier_id].present?
      qm = @general_question.question_modifiers.find_by_id(params[:delete_question_modifier_id])
      @general_question.question_modifiers.delete(qm)
      flash.now[:notice] = "Question Modifier successfully removed."
    elsif params[:refresh_html].present?
      flash.now[:notice] = "Displayed HTML result has been refreshed."
    end
    @question_modifiers_not_yet_added = QuestionModifier.all.order("name ASC")
    @generated_html = @general_question.build_html()
  end


  # POST /general_questions
  # POST /general_questions.json
  def create
    @general_question = GeneralQuestion.new(general_question_params)

    respond_to do |format|
      if @general_question.save
        format.html { redirect_to @general_question, notice: 'General question was successfully created.' }
        format.json { render action: 'show', status: :created, location: @general_question }
      else
        format.html { render action: 'new' }
        format.json { render json: @general_question.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /general_questions/1
  # PATCH/PUT /general_questions/1.json
  def update
    if params[:identifier].present?
      redirect_to edit_general_question_path(@general_question, :identifier => params[:identifier])
    else
      respond_to do |format|
        orig_question_name = @general_question.name
        if @general_question.update(general_question_params)
          if params[:general_question] && params[:general_question][:question_modifier_ids]
            params[:general_question][:question_modifier_ids].each do |qm|
              question_mod = QuestionModifier.find_by_id(qm)
              if question_mod
                @general_question.question_modifiers << question_mod
              end
            end
          end
          @general_question.save
          @general_question.update_qma_names if orig_question_name != @general_question.name
          format.html { redirect_to edit_general_question_path(@general_question), notice: 'General question was successfully updated.' }
          format.json { head :no_content }
        else
          format.html {
            @question_modifiers_not_yet_added = QuestionModifier.all.order("name ASC")
            @generated_html = @general_question.build_html()
            render action: 'edit'
          }
          format.json { render json: @general_question.errors, status: :unprocessable_entity }
        end
      end
    end

#    respond_to do |format|
#      if @general_question.update(general_question_params)
#        format.html { redirect_to @general_question, notice: 'General question was successfully updated.' }
#        format.json { head :no_content }
#      else
#        format.html { render action: 'edit' }
#        format.json { render json: @general_question.errors, status: :unprocessable_entity }
#      end
#    end
  end

  # DELETE /general_questions/1
  # DELETE /general_questions/1.json
  def destroy
    @general_question.destroy
    respond_to do |format|
      format.html { redirect_to general_questions_url }
      format.json { head :no_content }
    end
  end

  def paged_list
    general_question_to_fields_func = -> (general_question) do
      {
        id:                 general_question.id,
        name:               general_question.name.try(:humanize),
        row_label:          general_question.label.try(:humanize),
        edit:               edit_general_question_path(general_question),
        destroy:            general_question_path(general_question)
      }
    end

    ordered_general_questions =  apply_ordering_to_query(GeneralQuestion.filter(params), GeneralQuestion::FIELDS_FOR_RESULTSET, params['order'])
    return_data = datatables_json_for_query_using_func(
      ordered_general_questions, general_question_to_fields_func
    )
    render json: return_data
  end

  def sort
    params[:qm_assignment].each_with_index do |id, index|
      @general_question.qm_assignments.where(id: id).update_all({position: index+1})
    end
    render nothing: true
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_general_question
      @general_question = GeneralQuestion.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def general_question_params
      params.require(:general_question).permit(:name, :label)
    end
end
