class FullBodyEvaluationsController < ApplicationController
  before_action :set_full_body_evaluation, only: [:show, :edit, :update, :destroy, :review]

  # GET /full_body_evaluations
  # GET /full_body_evaluations.json
  def index
    @full_body_evaluations = FullBodyEvaluation.all
  end

  # GET /full_body_evaluations/1
  # GET /full_body_evaluations/1.json
  def show
    @claim = @full_body_evaluation.claim
#binding.pry #cs
#cs merge    @html_repository = NokogiriEnabledHtmlRepository.find_by(name: 'full_body_evaluation' )
#cs merge    @form = @html_repository.document_fragment
    @form = @full_body_evaluation.html_document_fragment
#binding.pry #cs
    respond_to do |format|
      format.html
      format.xml do
#binding.pry #cs
        render :xml => @full_body_evaluation.to_xml
      end
      format.text do
        render :text => @full_body_evaluation.to_txt
      end
      format.pdf do
        params[:show_all].present? ? @show_all = true : @show_all = false
        render :pdf => "cui-#{@full_body_evaluation.guid}.pdf",
               :layout => "pdf.html",
               :locals => {claim: @claim, form: @form, evaluation: @full_body_evaluation}
      end
    end
    
  end

  # GET /full_body_evaluations/new
  def new
    @full_body_evaluation = FullBodyEvaluation.new
  end

  # GET /full_body_evaluations/1/edit
  def edit
    if(@full_body_evaluation.completed_at.nil?)
      @the_html_to_display = @full_body_evaluation.html_for_diagnoses
    else
      @the_html_to_display = "Empty"
      redirect_to full_body_evaluation_path(@full_body_evaluation)
    end
#binding.pry #cs
  end

  # POST /full_body_evaluations
  # POST /full_body_evaluations.json
  def create
    @full_body_evaluation = FullBodyEvaluation.new(full_body_evaluation_params)

    respond_to do |format|
      if @full_body_evaluation.save
        format.html { redirect_to @full_body_evaluation, notice: 'Full body evaluation was successfully created.' }
        format.json { render action: 'show', status: :created, location: @full_body_evaluation }
      else
        format.html { render action: 'new' }
        format.json { render json: @full_body_evaluation.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /full_body_evaluations/1
  # PATCH/PUT /full_body_evaluations/1.json
  def update
    the_local_params = params
#binding.pry #cs

#    @full_body_evaluation.update( full_body_evaluation_params )
    @full_body_evaluation.update!( full_body_evaluation_params )
#cs merge    the_evaluation_was_saved = @full_body_evaluation.update_all_contents( params )   ???!!!!!  Do we need to be saving on Complete? I think it is stomping on the repository
#binding.pry #cs
    
    case params[:commit]
    
      when "Review"
#binding.pry #cs        
      begin
        authorize! :review, @full_body_evaluation
        the_evaluation_was_saved = @full_body_evaluation.update_all_contents( params )   #cs merge


#cs        # Add suggested exams
#cs        ids = params.select { |k,v| k.start_with? "_suggested_" }
#cs                    .map { |k,v| k.split("_")[2] }
#cs                    .each do |spec_id|
#cs          id = EvaluationSpec.find_by_spec_id(spec_id).id
#cs          evaluation = @claim.evaluations.create(
#cs            evaluation_spec_id: id,
#cs            assigner: current_user,
#cs            user: current_user)
#cs          contention = Evaluation.find(params["id"]).contentions.first
#cs          contention.evaluations << evaluation
#cs        end

#cs        @form = update_evaluation_and_create_form(@evaluation)
#cs        @form.validate
#cs        @evaluation.check_dependencies
        @full_body_evaluation.review!

        # flash[:notice] = "Please review your evaluation, check for errors, and hit complete when you are satisfied."
#cs        redirect_to review_claim_evaluation_path(@claim, @evaluation)
        redirect_to review_full_body_evaluation_path(@full_body_evaluation)
#cs      rescue FML::ValidationErrors => errors
#cs        @errors = errors
#cs        @suggested_exams = get_suggested_exams(@form)
#cs        flash.now[:alert] = "This form contains the following errors"
#cs        render :edit
      rescue DependencyError => errors
        @errors = errors
#cs        @suggested_exams = get_suggested_exams(@form)
        flash.now[:alert] = errors.errors[0].message
        render :edit
      rescue CredentialError
        # we only care about this exception on submissions
        flash[:notice] = "Please review your evaluation, check for errors, and hit complete when you are satisfied."
#cs        redirect_to review_claim_evaluation_path(@claim, @evaluation)
        redirect_to review_full_body_evaluation_path(@full_body_evaluation)
      end

      when "Complete"
#binding.pry #cs
        authorize! :complete, @full_body_evaluation
        @claim = @full_body_evaluation.claim
        @form = @full_body_evaluation.html_document_fragment
        the_local_hash = {"vha_user_electronic_signature" => params["full_body_evaluation"]["vha_user_electronic_signature"],
                          "vha_user_vista_access_code"    => params["full_body_evaluation"]["vha_user_vista_access_code"],
                          "vha_user_vista_verify_code"    => params["full_body_evaluation"]["vha_user_vista_verify_code"]     }
#binding.pry #cs
        @full_body_evaluation.update_attributes(the_local_hash)
        begin
          @full_body_evaluation.complete!(current_user)
        rescue DependencyError => errors
#binding.pry #cs
#cs        @form = @evaluation.form
#cs        @suggested_exams = get_suggested_exams(@form)
          @errors = errors
          flash.now[:alert] = errors.errors[0].message
          return render :edit
        rescue CredentialError => error
#cs        @form = @evaluation.form
#cs        @suggested_exams = get_suggested_exams(@form)
          flash.now[:alert] = error.message
          @errors = errors
#binding.pry #cs
          return render :review
        end
        flash[:notice] = "Evaluation completed"
        #start
        @exam = @full_body_evaluation.examination
        @exam.examination_state = ExaminationState.find_by_code("COMPLETED")
        @exam.examination_state_start_date = DateTime.current
        @exam.save
        # Send Appointment completed event
        @exam_request = ExamRequest.find_by_id(@exam.exam_request_id)
        appointmentCompletedEventNotification = AppointmentCompletedEvent.new
#cs merge        eventId = appointmentCompletedEventNotification.build_notification(@exam_request.claim_id, @exam.contention_id, @exam_request.site_id)
        eventId = appointmentCompletedEventNotification.build_notification(@exam_request.claim_id, :unused, @exam_request.site_id)
        VlerDASJob.sendNotification(appointmentCompletedEventNotification, eventId, @exam_request.claim_id, "Appointment Completed Event Notification")

        flash[:notice] = "Examination is now ready for review by supervising clinician."
        #end
        redirect_to edit_examination_path(@full_body_evaluation.examination), notice: 'Evaluation is complete.'

      else # Save, Save as Update
#binding.pry #cs
        the_evaluation_was_saved = @full_body_evaluation.update_all_contents( params )   #cs merge

#        @html_repository = NokogiriEnabledHtmlRepository.find_by(name: 'full_body_evaluation' )
#        @form = @html_repository.document_fragment
        @the_html_to_display = @full_body_evaluation.html_for_diagnoses
        respond_to do |format|
#binding.pry #cs
          if the_evaluation_was_saved
#cs          if @full_body_evaluation.update(full_body_evaluation_params)
#binding.pry #cs
            format.html { render action: 'edit' }
    #cs        format.html { redirect_to @full_body_evaluation, notice: 'Full body evaluation was successfully updated.' }
            format.json { head :no_content }
          else
            format.html { render action: 'edit' }
            format.json { render json: @full_body_evaluation.errors, status: :unprocessable_entity }
          end
        end
    end
    
  end
  
  def review
    @claim = @full_body_evaluation.claim
#binding.pry #cs
#cs#cs     @form = update_evaluation_and_create_form(@evaluation)  #cs 2016-09-12
#cs    @form = FML::Form.from_json(@evaluation.doc.to_json)
#cs merge    @html_repository = NokogiriEnabledHtmlRepository.find_by(name: 'full_body_evaluation' )
#cs merge    @form = @html_repository.document_fragment
    @form = @full_body_evaluation.html_document_fragment
  end
  

  # DELETE /full_body_evaluations/1
  # DELETE /full_body_evaluations/1.json
  def destroy
    @full_body_evaluation.destroy
    respond_to do |format|
      format.html { redirect_to full_body_evaluations_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_full_body_evaluation
      @full_body_evaluation = FullBodyEvaluation.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def full_body_evaluation_params
#cs      params[:full_body_evaluation]
 #cs  params.permit!
      params.permit(:full_body_evaluation, :full_body_evaluation_spec_id, :evaluation_spec_id, :vha_user_vista_access_code, :vha_user_vista_verify_code,
                                                   :vha_user_electronic_signature, :user_id)
#cs   params.require(:full_body_evaluation).permit(:evaluation_spec_id, :vha_user_vista_access_code, :vha_user_vista_verify_code,
#cs                                                :vha_user_electronic_signature, :user_id)
    end
#  def evaluation_params
#    params.require(:evaluation).permit(:evaluation_spec_id, :vha_user_vista_access_code, :vha_user_vista_verify_code,
#                                       :vha_user_electronic_signature, :user_id)
#  end

end
