class ExaminationProcessorsController < ApplicationController
  include ContentionHelper
  before_action :set_examination_processor, only: [:show, :edit, :update, :destroy]
  check_authorization
  authorize_resource class: false

  TIME_VALUES = ['00:00', '00:30', '01:00']

  # GET /examination_processors
  # GET /examination_processors.json
  def index
    @examination_processors = ExaminationProcessor.all
  end

  # GET /examination_processors/1
  # GET /examination_processors/1.json
  def show
  end

  # GET /examination_processors/new
  def new
    @examination_processor = ExaminationProcessor.new
  end

  # GET /examination_processors/1/edit
  def edit
  end

  def view_examination
    flash.clear
    @examination = Examination.find_by_identifier(params[:id])
    @sites = Site.all
    @examination_history = Array(ExaminationHistory.where(examination_id: params[:id]).order(created_at: :DESC))
    @exam_request = ExamRequest.find_by_id(@examination.exam_request_id)

    if (@examination.examination_state.code == "CANCELLED" && !@examination.acknowledged)
      redirect_to acknowledge_path(:id => @examination.identifier)
    end
  end

  def cancel_examination
    @examination = Examination.find_by_id(params[:e_id])
    if (@examination == nil)
      redirect_to dashboards_path, notice: 'Unable to locate the examination.'
    end
    examinationState = ExaminationState.find_by_code "CANCELLED"
    if examinationState != nil && examinationState.code == "CANCELLED"
      #@examination.examination_state_id = examinationState.id
      @examination.acknowledged = true
      @examination.save

      examRequest = ExamRequest.find_by_id(@examination.exam_request_id)
      notes = current_user.first_name + " " + current_user.last_name + " acknowledged the cancellation of the examination" + " (" + appendContentionNames(@examination.contentions) + ")"
      @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
      @exam_request_history.save

      redirect_to dashboards_path, notice: 'Examination successfully cancelled.'
    end
  end

  def ack
    @examination = Examination.find_by_identifier(params[:id])
    if (@examination != nil && @examination.examination_state != nil && @examination.examination_state.code == "CANCELLED")
      @exam_request = ExamRequest.find_by_claim_id(@examination.claim_id)
      @examination_history = Array(ExaminationHistory.where(examination_id: @examination.id).order(created_at: :DESC))
    else
      flash[:alert] = "Unable to locate the examination"
      redirect_to dashboards_path
    end
  end

  def ack_submit
    @examination = Examination.find_by_identifier(params[:e_id])
    if (@examination != nil && @examination.examination_state != nil && @examination.examination_state.code == "CANCELLED")
      examination_schedule = @examination.examination_schedules.flatten.select{|es| es.active == true}
      if (@examination.clinician != nil && examination_schedule[0].exam_date_time != nil)
        @examination.clinician_acknowledged = true
      else
        @examination.acknowledged = true
      end
        @examination.save

      addExaminationHistory(@examination.contentions, @examination)
      flash[:notice] = "Acknowledgement successful"
    else
      flash[:alert] = "Unable to locate the examination"
    end
    redirect_to dashboards_path
  end

  def reschedule
    @examination = Examination.find_by_identifier(params[:id])

    @examination_schedule = ExaminationSchedule.new
    @examination_schedules = @examination.examination_schedules.flatten.select{|ex| ex.active==true}
    if (@examination_schedules != nil && @examination_schedules.count > 0)
      @examination_schedule = @examination_schedules[0]
    end
    @sites = Site.all
    @examination_history = Array(ExaminationHistory.where(examination_id: params[:id]).order(created_at: :DESC))
    @exam_request = ExamRequest.find_by_id(@examination.exam_request_id)
  end

  def reschedule_submit
    @examination = Examination.find_by_identifier(params[:e_id])

    if @examination.nil?
      redirect_to dashboards_path, alert: 'Unable to locate the examination.'
      return
    end
    @examination_schedule = @examination.examination_schedules[0]
    @sites = Site.all
    @examination_history = Array(ExaminationHistory.where(examination_id: params[:id]).order(created_at: :DESC))
    @exam_request = ExamRequest.find_by_id(@examination.exam_request_id)

    if params[:examination_date].present? && params[:examination_date_time].present?
      apptDateAndTime = Time.strptime(params[:examination_date] + " " + params[:examination_date_time], "%m/%d/%Y %H:%M")

      @examination.examination_state = ExaminationState.find_by_code "SCHEDULED"
      @examination.save

      examinationSchedule = ExaminationSchedule.new
      examinationSchedule.exam_date_time = apptDateAndTime
      examinationSchedule.active = true
      examinationSchedule.examination_id = @examination.id

      examinationScheduleExists = false
      @examination_schedule = @examination.examination_schedules[0]
      if (@examination_schedule != nil)
        @examination_schedule = @examination.examination_schedules.flatten.select{|ex| ex.active==true}
        if (@examination_schedule != nil && @examination_schedule.count > 0)
          @examination_schedule[0].active = false
          @examination_schedule[0].save

          examinationScheduleExists = true
        end
      end

      if (examinationScheduleExists)
        examinationSchedule.save
        flash[:notice] = "Examination successfully rescheduled"

        if @examination.clinician
          clinician = User.find(@examination.clinician)
          ExamManagementMailer.examination_scheduled(clinician).deliver_now
        end
        #Send Appointment Scheduled Notification
        appointmentScheduledEventNotification = AppointmentScheduledEvent.new
        eventId = appointmentScheduledEventNotification.build_notification("RESCHEDULE", @exam_request.claim_id, @examination, @examination_schedule[0], @exam_request.site_id)
        VlerDASJob.sendNotification(appointmentScheduledEventNotification, eventId, @exam_request.claim_id, "Appointment Scheduled Event Notification")
      else
        flash[:alert] = "Examination Record not found."
      end
    else
      flash.now[:alert] = "Please provide reschedule day and time."
      render :reschedule
      return
    end

    redirect_to dashboards_path
  end

  def cancelled_examination
    @examination = Examination.find_by_identifier(params[:id])
    if (@examination != nil && @examination.examination_state != nil && @examination.examination_state.code == "CANCELLED")
      @exam_request = ExamRequest.find_by_claim_id(@examination.claim_id)
      @examination_history = Array(ExaminationHistory.where(examination_id: @examination.id).order(created_at: :DESC))
    else
      flash[:alert] = "Unable to locate the examination"
      redirect_to dashboards_path
    end
  end

  def schedule_examination
   ActiveRecord::Base.transaction do
    @examination = Examination.find_by_identifier(params[:id])

    if @examination.nil?
      redirect_to dashboards_path, notice: 'Unable to locate the examination.'
    end

    @sites = Site.all
    @examination_history = Array(ExaminationHistory.where(examination_id: params[:id]).order(created_at: :DESC))
    @exam_request = ExamRequest.find_by_id(@examination.exam_request_id)

    examinationState = ExaminationState.find_by_id(@examination.examination_state_id)
    if examinationState != nil && examinationState.code == ExaminationStateHelper::CANCELLED
      render :cancel_examination
      return
    end

    if params[:examination_date].present?
      m, d, y = params[:examination_date].split('/')
      valid_date = Date.valid_date?(y.to_i, m.to_i, d.to_i)
    end

    if params[:examination_date].present? && params[:examination_date_time].present? && valid_date
      apptDateAndTime = Time.strptime(params[:examination_date] + " " + params[:examination_date_time], "%m/%d/%Y %H:%M")

      @examination.examination_state = ExaminationState.find_by_code "SCHEDULED"

      examinationSchedules = @examination.examination_schedules.flatten.select{|es| es.active == true}
      if (examinationSchedules == nil || examinationSchedules.count != 1)
        redirect_to dashboards_path, alert: "Unable to schedule the examination. Please contact your system administrator."
        return
      else

        examinationSchedules[0].exam_date_time = apptDateAndTime
        examinationSchedules[0].save
        @examination.save

        if @examination.clinician
          clinician = User.find(@examination.clinician)
          ExamManagementMailer.examination_scheduled(clinician).deliver_now
        end

        appointmentScheduledEventNotification = AppointmentScheduledEvent.new
        eventId = appointmentScheduledEventNotification.build_notification("SCHEDULE", @exam_request.claim_id, @examination, examinationSchedules[0], @exam_request.site_id)
        VlerDASJob.sendNotification(appointmentScheduledEventNotification, eventId, @exam_request.claim_id, "Appointment Scheduled Event Notification")

        redirect_to dashboards_path, notice: 'Examination successfully scheduled.'
        return
      end
    elsif request.post?
      flash.now[:alert] = "Please provide a day/date and time."
      render :schedule_examination
    end
   end
  end


  def review_examination
    @examination = Examination.find_by_id(params[:id])
    @contentions = @examination.contentions
    if params[:examination_reviewed]
      @examination.examination_state = ExaminationState.find_by_code "REVIEWED"
      @examination.reviewed_by = current_user.id
      @examination.reviewed_at = DateTime.now
      @examination.save
      redirect_to dashboards_path, notice: 'Examination successfully marked as Reviewed.'
    elsif params[:examination_rejected]
      @examination.examination_state = ExaminationState.find_by_code "REJECTED"
      @examination.save
      redirect_to dashboards_path, notice: 'Examination has been rejected and will be sent back to the clinician to update.'
    elsif params[:add_note]
      message = params[:Note]
      from_supervisor = current_user.id
      to_clinician = @examination.clinician
      note = ExaminationNote.create(from_id: from_supervisor, to_id: to_clinician, note: message)
      @examination.examination_notes << note
      @examination.save
    end
  end


  def modify
  end

  def create
    flash.clear

    @examination = Examination.find_by_id(params[:e_id])
    @sites = Site.all
    #retrieve the examination history based on the examination_id
    @examination_history = Array(ExaminationHistory.where(examination_id: params[:e_id]).order(created_at: :DESC))

    if params[:examination_confirm]
      @examination_from_db = Examination.find_by_id(params[:e_id])

      #check to see if clinician has been assigned to the examination
      if @examination_from_db.clinician != nil
        flash[:notice] = "Examination state has been changed to 'Ready To Be Scheduled'."

        #update examination status to READY_TO_BE_SCHEDULED
        @examinationState = ExaminationState.find_by_code "READY_TO_BE_SCHEDULED"
        @examination.examination_state_id = @examinationState.id
        @examination.examination_state_start_date = DateTime.current
        @examination.save
        site_scheduling_users = User.all.includes(:sites).where(:sites => {name: @examination.site.name}).includes(:site_role_sets).where(:site_role_sets => {scheduling: "true"})

        # TODO:Refactor
        if site_scheduling_users.present?
          site_scheduling_users.each do |ss|
            ExamManagementMailer.examination_ready_to_schedule(ss).deliver_now
          end
        end

        redirect_to dashboards_path
      else
        flash[:alert] = "Examination has to be assigned to a clinician."
        render :view_examination
      end
    elsif params[:modify_submit]
      #Check to see if a new site was picked.
      @examination_from_db = Examination.find_by_id(params[:e_id])
      puts @examination_from_db.site_id
      puts params[:site_id]
      if @examination_from_db.site_id.to_s == params[:site_id]
        puts "Site did not change"
        render :view_examination
      else
        #Create ExaminationHistory
        notes = current_user.first_name + " " + current_user.last_name + " changed the site from "
        notes = notes + Site.find_by_id(@examination_from_db.site_id).name + " to " + Site.find_by_id(params[:site_id]).name + "."
        examination_history = ExaminationHistory.new(examination_id: @examination_from_db.id, notes: notes)
        examination_history.save

        #update the examination and save
        @examination_from_db.site_id = params[:site_id]
        @examination_from_db.assign_a_clinician(nil) #cs 2016-09-13
#cs 2016-09-13        @examination_from_db.clinician = nil
        @examination_from_db.save

        #retrieve the examination history based on the examination_id
        @examination_history = Array(ExaminationHistory.where(examination_id: params[:e_id]).order(created_at: :DESC))

        flash[:notice] = "Examination has been successfully updated."
        redirect_to dashboards_path
      end
    elsif params[:assign_clinician_submit]
      @examination_from_db = Examination.find_by_id(params[:e_id])
      notes = ""
#binding.pry #cs
      if @examination_from_db.clinician.to_s == params[:clinician_id]
        puts "Clinician did not change"
      else
        new_clinician = User.find_by_id(params[:clinician_id])
        if @examination_from_db.clinician.to_s.length > 0
          #Create ExaminationHistory
          notes = current_user.first_name + " " + current_user.last_name + " changed the clinician from "
          notes = notes + User.find_by_id(@examination_from_db.clinician).first_name + " " + User.find_by_id(@examination_from_db.clinician).last_name
          notes = notes + " to "
          notes = notes + new_clinician.name + "."
        else
          notes = current_user.first_name + " " + current_user.last_name + " assigned "
          notes = notes + new_clinician.name
          notes = notes + " as the clinician."
        end

        examination_history = ExaminationHistory.new(examination_id: @examination_from_db.id, notes: notes)
        examination_history.save

#binding.pry #cs
        @examination_from_db.assign_a_clinician(params[:clinician_id]) #cs 2016-09-13
#cs 2016-09-13        @examination_from_db.clinician = params[:clinician_id]
#cs 2016-09-15 after Isaar changed it back for some reason.  'assign_a_clinician' MUST be used to propagate through to the evaluatoin...  @examination_from_db.clinician = params[:clinician_id]
#binding.pry #cs
        @examination_from_db.save

        @exam_request = ExamRequest.find_by_id(@examination_from_db.exam_request_id)

        flash[:notice] = "Examination has been successfully updated."
        ExamManagementMailer.examination_clinician_assigned(new_clinician).deliver_now
      end
      @examination = @examination_from_db
      #retrieve the examination history based on the examination_id
      @examination_history = Array(ExaminationHistory.where(examination_id: params[:e_id]).order(created_at: :DESC))
      render :view_examination
    elsif params[:modify_cancel]
      render :view_examination
    elsif params[:change_site]
      render :change_site
    elsif params[:assign_clinician]
      #retrieve clinicians
      @clinicians = User.get_clinicians_by_site(@examination.site_id)
      @data = Hash.new
      if @clinicians != nil
        @clinicians.each do |key, value|
          puts key["first_name"]
          puts value
          @data[key["first_name"] + " " + key["last_name"]] = key["id"]
        end
      end
      puts @data
      render :assign_clinician
    else
      redirect_to dashboards_path
    end
  end

  def assign_clinician
  end

  def change_site
  end

  # POST /examination_processors
  # POST /examination_processors.json
  def create_old
    @examination_processor = ExaminationProcessor.new(examination_processor_params)

    respond_to do |format|
      if @examination_processor.save
        format.html { redirect_to @examination_processor, notice: 'Examination processor was successfully created.' }
        format.json { render action: 'show', status: :created, location: @examination_processor }
      else
        format.html { render action: 'new' }
        format.json { render json: @examination_processor.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /examination_processors/1
  # PATCH/PUT /examination_processors/1.json
  def update
    respond_to do |format|
      if @examination_processor.update(examination_processor_params)
        format.html { redirect_to @examination_processor, notice: 'Examination processor was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @examination_processor.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /examination_processors/1
  # DELETE /examination_processors/1.json
  def destroy
    @examination_processor.destroy
    respond_to do |format|
      format.html { redirect_to examination_processors_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_examination_processor
      @examination_processor = ExaminationProcessor.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def examination_processor_params
      params[:examination_processor]
    end

  def retrieve_examination_history(examination_id)
    result = Array(ExaminationHistory.where(examination_id: params[:e_id]).order(created_at: :DESC))
    return result
  end

  def addExaminationHistory(contentions, examination)
    notes = current_user.first_name + " " + current_user.last_name + " acknowledged the cancellation of examination for "
    contentions.each_with_index do |contention, index|
      separator = ""
      if index > 0 && index == contentions.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      notes = notes + separator + contention.contention_details[0].name
    end
    @examination_history = ExaminationHistory.new(examination_id: examination.id, notes: notes)
    @examination_history.save
  end
end
