class ExamRequestProcessorsController < BaseExaminationsController
  before_action :set_exam_request_processor, only: [:show, :edit, :update, :destroy]
  skip_before_action :clear_current_site
  

  # GET /exam_request_processors
  # GET /exam_request_processors.json
  def index_old
    @exam_request_processors = ExamRequestProcessor.all
    @all_sites = Site.all
    if @all_sites != nil
      @sites = @all_sites.map{ |s| [s.name, s.id] }
    end
  end

  def index

    @contention_data = get_contention_data
   
    puts @contention_data
    @claim_contentions = Hash.new
    
    if @contention_data != nil
      @contention_data.each do |key, value|
        #binding.pry
        @claim_contentions[key["first_name"] + " " + key["last_name"] + " (" + key["file_number"] + ") - " + key["name"]] = key["id"]
      end
    end

    @all_sites = Site.all
    if @all_sites != nil
      @sites = @all_sites.map{ |s| [s.name, s.id] }
    end
    if current_user.is_developer?
      @exam_request_processor = ExamRequestProcessor.new
      render :new
    else
      redirect_to root_path, alert: "You are not authorised to create an examination."
    end
  end

  # GET /exam_request_processors/1
  # GET /exam_request_processors/1.json
  def show
  end

  # GET /exam_request_processors/new
  def new
    @all_sites = Site.all
    if @all_sites != nil
      @sites = @all_sites.map{ |s| [s.name, s.id] }
    end
    if current_user.is_developer?
      @exam_request_processor = ExamRequestProcessor.new
    else
      redirect_to root_path, alert: "You are not authorised to create an examination."
    end
  end

  # GET /exam_request_processors/1/edit
  def edit
  end

  # POST /exam_request_processors
  # POST /exam_request_processors.json
  def create
    @exam_request_processor = ExamRequestProcessor.new()

    #binding.pry

    @examinationState = ExaminationState.find_by_code "PENDING"

    @examination = Examination.new(title: "Test", contention_id: params[:contention_id], site_id: params[:site_id], examination_state_id: @examinationState.id)
    @examination.save

    current_user.email = "cui.testing@gmail.com"
    #binding.pry
    UserMailer.send_create_examination_email(current_user).deliver_now
    
    respond_to do |format|
     # if @exam_request_processor.save
      if true
        format.html { redirect_to @exam_request_processor, notice: 'Examination was successfully created.' }
        format.json { render action: 'show', status: :created, location: @exam_request_processor }
        #format.html { redirect_to url_for(:controller => :examinations, :action => :index, :resp => 'n') }
      else
        format.html { render action: 'new' }
        format.json { render json: @exam_request_processor.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /exam_request_processors/1
  # PATCH/PUT /exam_request_processors/1.json
  def update
    respond_to do |format|
      if @exam_request_processor.update(exam_request_processor_params)
        format.html { redirect_to @exam_request_processor, notice: 'Exam request processor was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @exam_request_processor.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /exam_request_processors/1
  # DELETE /exam_request_processors/1.json
  def destroy
    @exam_request_processor.destroy
    respond_to do |format|
      format.html { redirect_to exam_request_processors_url }
      format.json { head :no_content }
    end
  end

  private

  def old_get_contention_data
    sql = " select c.first_name, c.last_name, c.file_number, con.id, con.name " +
          " from   claims c, contentions con " +
          " where  c.id = con.claim_id"
    results = ActiveRecord::Base.connection.exec_query(sql)
    if results.present?
      results.each do |row|
        puts row
      end
      return results
    else
      return nil
    end
  end
    # Use callbacks to share common setup or constraints between actions.
    def set_exam_request_processor
      @exam_request_processor = ExamRequestProcessor.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def exam_request_processor_params
      params[:exam_request_processor]
    end
end
