class ExamRequestController < ApplicationController
  include ClarificationHelper, ExamRequestStateHelper
  before_action :get_exam_request, only: [:view_exam_request, :ack, :cancelExamRequest, :view_cancelled_exam_request]
  before_action :get_exam_request_using_er_id, only: [:ack_submit, :cancel_submit, :get_clarification, :select_contentions_submit ]
  before_action :redirect_if_no_exam_request, only: [:view_exam_request, :cancel_submit, :view_cancelled_exam_request]
  check_authorization
  authorize_resource

  def index

  end

  def new
    @claim = Claim.new
    @contentions = @claim.contentions + [Contention.new]
    @all_sites = Site.all
    if @all_sites.present?
      @sites = @all_sites.map{ |s| [s.name, s.id] }
    end
  end

  def view_exam_request
    if (isExamRequestPendingCancellation(@exam_request.exam_request_state_id))
      redirect_to action: "cancelExamRequest", id: @exam_request.identifier
    else
      prepareExamRequestData(@exam_request)

      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id).includes(:examination_schedules, :contentions).flatten.select{|e| e.examination_schedules.flatten.select{|es| es.active==true}}
      @contentions = loadContentions(@exam_request)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: params[:id]).order(created_at: :DESC))
    end
  end

  def ack
    if (@exam_request.present? && @exam_request.exam_request_state.present? && @exam_request.exam_request_state.code == "CANCELLED")

      prepareExamRequestData(@exam_request)
      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id)
      @contentions = loadContentions(@exam_request)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: params[:id]).order(created_at: :DESC))
    else
      flash[:alert] = "Unable to locate the ExamRequest"
      redirect_to dashboards_path
    end
  end

  def ack_submit
    if (@exam_request.present? && @exam_request.exam_request_state.present? && @exam_request.exam_request_state.code == "CANCELLED")
      @exam_request.cancellation_acknowledged = true
      @exam_request.save

      notes = current_user.first_name + " " +current_user.last_name + " acknowledged the exam request cancellation"
      @exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes)
      @exam_request_history.save

      flash[:notice] = "Acknowledgement successful"
    else
      flash[:alert] = "Unable to locate the ExamRequest"
    end
    redirect_to dashboards_path
  end

  def cancelExamRequest
    prepareExamRequestData(@exam_request)

    render :cancel_exam_request
  end

  def cancel_submit
    if (isExamRequestPendingCancellation(@exam_request.exam_request_state_id))
      @exam_request.exam_request_state_id = getCancelledExamRequestStateId()
      @exam_request.save

      flash[:notice] = "Exam Request successfully cancelled"
      redirect_to dashboards_path
    end
  end

  def view_cancelled_exam_request
    if (isExamRequestCancelled(@exam_request.exam_request_state_id))
      prepareExamRequestData(@exam_request)

      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id)
      @contentions = loadContentions(@exam_request)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: params[:id]).order(created_at: :DESC))

    else
      flash[:alert] = "Unable to locate the Exam Request record."
      redirect_to dashboards_path
    end
  end

  def loadContentions(exam_request)
    @claim = Claim.find_by_id(exam_request.claim_id)
    @claim.contentions.includes(:contention_details)
  end

  def prepareExamRequestData(exam_request)
    @claim = Claim.find_by_id(exam_request.claim_id)
    request_object = RequestObject.all.order('created_at desc').find_by_claim_id exam_request.claim_id
    @contractorName = ""
    @gender = ""
    @maskedSsn = getMaskedSsn(@claim.patient_ssn)
    if request_object.present?
      request_object_doc = Nokogiri::XML(request_object.xml)

      @veteranServiceMemberInfo = XmlHelper.getDoc(request_object_doc, 'VeteranServiceMemberInfo')
      @gender = @veteranServiceMemberInfo['gender']

      @claimInformation = XmlHelper.getDoc(request_object_doc, 'ClaimInformation')
      @claimDate = @claimInformation['claimDate']

      # is postSeparation the same as SeparationStatus?
      @postSeparation = @claimInformation['postSeparation']

      @benefitType = @claimInformation['benefitProgramType']

      @preferredGeographicLoc = XmlHelper.getDoc(request_object_doc, 'PreferredGeographicLocation')
      @PAddress = ""
      if (@preferredGeographicLoc != nil)
        @preferredAddress1 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address1').children.text
        @preferredAddress2 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address2').children.text
        @preferredAddress3 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address3').children.text
        @preferredAddress4 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address1').children.text
        @preferredCity = XmlHelper.getDoc(@preferredGeographicLoc, 'City').children.text
        @preferredState = XmlHelper.getDoc(@preferredGeographicLoc, 'State').children.text
        @preferredZip = XmlHelper.getDoc(@preferredGeographicLoc, 'ZipCode').children.text
        @PAddress = @preferredAddress1 + "\n" + @preferredCity + ",  " + @preferredState + "  " + @preferredZip
      end

      @examRelatedContentions = XmlHelper.getDoc(request_object_doc, 'ExamRelatedContentions')
      @contentionType = XmlHelper.getDoc(@examRelatedContentions, 'ExamRelatedContention')['contentionType']

    end
  end

  def getMaskedSsn(ssn)
    maskedSsn = "-"
    if (ssn.present? && ssn.length > 5)
      maskedSsn = "***-**-"
      maskedSsn = maskedSsn + ssn.split(//).last(4).join
    end
    maskedSsn
  end

  def get_clarification
    @select_contention_caption = "You opted to get clarification. Please select one or more contentions from the below entries"

    @claim = Claim.find_by_id(@exam_request.claim_id)
    if @claim.present? && @claim.contentions.present? && @claim.contentions.length > 0
      @contentions = @claim.contentions
    end
    @page = "GetClarification"
    render :select_contentions
  end

  def handleGetClarification
    @exam_request = ExamRequest.find_by_identifier(session[:id])
    selected_contention_ids = session[:c_ids]
    @contentions = Contention.find(selected_contention_ids)

    session[:id] = ""
    session[:c_ids] = ""

    if (session[:cr] == "" || session[:cr].nil?)
     @cr = ClarificationRequest.new
     @cr.clarificationText = Hash.new
     selected_contention_ids.each do |contentionId|
       contention = Contention.find_by_id(contentionId)
       @cr.clarificationText[contention.exam_related_contention_id] = ""
     end
    else
      @cr = session[:cr]
      session[:cr] = ""
    end

    render :clarification_info
  end

  def clarification_info_submit
    @exam_request = ExamRequest.find_by_identifier(params["er_id"])

    selectedContentionIds = params[:c_ids]
    if selectedContentionIds.nil?
      redirect_to dashboards_path
    end
    clarificationRequest = buildClarificationRequest(params)

    eventId = buildAndSendClarificationRequestEvent(current_user, params["er_id"], selectedContentionIds, clarificationRequest)

    createContentionDetail(selectedContentionIds, clarificationRequest, eventId)

    flash[:notice] = "Clarification Request sent successfully"
    redirect_to "/erp/view_exam_request/"+ @exam_request.identifier.to_s
  end

  def createContentionDetail(selectedContentionIds, clarificationRequest, eventId)
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)

      existingContentionDetail = contention.contention_details.flatten.select{|cd| cd.active == true}

      clarificationInfo = clarificationRequest.clarificationText

      contentionDetail = ContentionDetail.create(contention_id: existingContentionDetail[0].contention_id, name: existingContentionDetail[0].name, description: existingContentionDetail[0].description, active: true, event_id: eventId)

      existingContentionDetail[0].active = false
      existingContentionDetail[0].save

      contentionDetail.save

      clarificationTypeRequest = ClarificationType.find_by_code("REQUEST")
      clarificationDetail = ClarificationDetail.create(contention_id: contention.id, event_id: eventId, text: clarificationInfo[contention.exam_related_contention_id], clarification_type: clarificationTypeRequest.id)
      clarificationDetail.save

    end
  end

  def buildClarificationRequest(params)
    cr = ClarificationRequest.new
    cr.clarificationReason = params[:clarificationReason]
    cr.primary = params[:primary]
    cr.alternate = params[:alternate]

    selectedContentionIds = params[:c_ids]
    if selectedContentionIds.nil?
      redirect_to dashboards_path
    end

    cr.clarificationText = params[:clarificationText]
    return cr
  end

  def redirectToHandleGetClarification(examRequestIdentifier, contentionIds)
    session[:id] = examRequestIdentifier
    session[:c_ids] = contentionIds
    redirect_to action: "handleGetClarification"
  end

  def select_contentions_submit
    @claim = Claim.find_by_id(@exam_request.claim_id)
    selected_contention_ids = params[:c_ids]

    if selected_contention_ids.present?
      if (params[:p] == 'GetClarification')
        redirectToHandleGetClarification(params[:er_id], params[:c_ids])
      else
        @selected_contentions = Contention.where(id: selected_contention_ids)
                                          .includes(:contention_details)
        render :create_exams
      end
    else
      @contentions = @claim.contentions.where(:is_contention_cancelled => nil)
                                       .includes(:contention_details)
      flash[:alert] = "Please select at least one contention.";
      if params[:p] == 'GetClarification'
        redirect_to action: "get_clarification", er_id: params[:er_id]
      else
        render :select_contentions
      end
    end
  end


  def view_contention
    @contention = Contention.find_by_identifier(params[:id])
    if @contention.nil?
      redirect_to dashboards_path, :alert => "Unable to find the contention"
    end

    #build clarification_details by eventId
    @event_ids = @contention.clarification_details.select(:event_id).map(&:event_id).uniq
    @clarificationByEventId = Hash.new
    if (@event_ids != nil && @event_ids.count > 0)
      @event_ids.each do |eventId|
        @clarificationByEventId[eventId] = ClarificationDetail.where(:event_id => eventId, :contention_id => @contention.id).order("created_at ASC")
      end
    end
  end

  def create
#binding.pry #csi
   ActiveRecord::Base.transaction do
    flash.clear
    if !params[:new_exam_request].present?
      @exam_request = ExamRequest.find_by_identifier(params[:er_id])
      prepareExamRequestData(@exam_request)

      @sites = Site.all
      @claim = Claim.find_by_id(@exam_request.claim_id)
      @contentions = nil
      if @claim.present? && @claim.contentions.present?
        @contentions = @claim.contentions.includes(:contention_details)
      end
    end
    if params[:assign_to_different_site]
      render :change_site
    elsif params[:get_clarification]
      redirect_to action: "get_clarification", er_id: params[:er_id]
    elsif params[:create_exams]
      # Check to see if there are multiple contentions. If yes, display the page to select a contention
      @claim = Claim.find_by_id(@exam_request.claim_id)
      @contentions = @claim.contentions.where(:is_contention_cancelled => nil)
                                       .includes(:contention_details)

      if @contentions.present?
        @select_contention_caption = "You have opted to create an examination. Please select one or more contentions from the below entries"
        render :select_contentions
      else
        flash[:alert] = "Examination cannot be created as there are no active contentions.";
        redirect_to :back
      end
    elsif params[:select_contentions_submit]
     redirect_to action: "select_contentions_submit", er_id: params[:er_id], c_ids: params[:contention_ids], p: params[:p]
    elsif params[:create_exams_submit]
      #create an examination using the contention and site from the ExamRequest
      @claim = Claim.find_by_id(@exam_request.claim_id)
      curr_site = Site.find_by_id(@exam_request.site_id)

      @examinationState = ExaminationState.find_by_code "PENDING"

      selected_contention_ids = params[:contention_ids]
      if selected_contention_ids.present?
        @examination = Examination.new(title: "Examination created ", claim_id: @claim.id, site_id: curr_site.id, examination_state_id: @examinationState.id, exam_request_id: @exam_request.id, purpose: params["purpose"], examination_state_start_date: DateTime.current)

        @examination.set_the_creating_user(current_user.id) # passing it along to the evaluation as assigner
        @examination.identifier = SecureRandom.uuid
        selected_contention_ids.each_with_index do |contention_id, index|
          contention = Contention.find_by_id(contention_id)
          @examination.contentions << contention
        end
        @examination.save

        examinationSchedule = ExaminationSchedule.create(examination_id: @examination.id, active: true)
        examinationSchedule.save

        @examination.examination_schedules << examinationSchedule

        addExamHistory(selected_contention_ids, @exam_request)
        addExaminationHistory(selected_contention_ids, @examination)
      end

      flash[:notice] = "Examination has been successfully created."
      site_triage_users = User.all.includes(:sites).where(:sites => {name: curr_site.name}).includes(:site_role_sets).where(:site_role_sets => {triage: "true"})

      site_triage_users.try(:each){|st|
       # ExamManagementMailer.examination_created(st).deliver_now
      }
      redirect_to dashboards_path

    elsif params[:change_site_submit]
      if @exam_request.site_id.to_s == params[:site_id]
        puts "Site did not change"
        @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: @exam_request.id).order(created_at: :DESC))
        render :view_exam_request
      else
        new_site = Site.find_by_id(params[:site_id])
        prev_site = Site.find_by_id(@exam_request.site_id)
        notes = current_user.name + " changed the site from " + prev_site.name + " to " + new_site.name + "."

        @exam_request.site_id = params[:site_id]
        @exam_request.save

        @exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes)
        @exam_request_history.save

        flash[:notice] = "Exam Request has been successfully assigned to " + new_site.name
        site_triage_users = User.all.includes(:sites).where(:sites => {name: new_site.name}).includes(:site_role_sets).where(:site_role_sets => {triage: "true"})
        site_triage_users.try(:each){|st|
          # ExamManagementMailer.exam_request_site_changed(st).deliver_now
        }
        redirect_to dashboards_path
      end
    elsif params[:new_exam_request]
      @claim = Claim.new()
      @claim.patient_ssn = params[:patient_ssn]
      @claim.file_number = params[:file_number]
      @claim.first_name = params[:first_name]
      @claim.middle_name = params[:middle_name]
      @claim.last_name = params[:last_name]
      @claim.date_of_birth = @claim.build_date_of_birth(params)
      @claim.facility_name = params[:facility_name]
      @claim.save

      @exam_request = ExamRequest.new()
      @exam_request.claim_id = @claim.id
      @exam_request.site_id = params[:site_id]
      @exam_request.identifier = SecureRandom.uuid
      @exam_request.request_date = @exam_request.build_request_date(params)
      @exam_request.exam_request_state = ExamRequestState.find_by_id(1)

      notes = "Scheduled Exam Request has been initiated by " + current_user.first_name + " " + current_user.last_name + "."
      @exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes)

      if @claim.save && @exam_request.save && @exam_request_history.save
        flash[:notice] = "Scheduled Exam Request has been successfully created."
        if params[:contention_name].present?
          @contention = Contention.create(
            name: params[:contention_name],
            claim_id: @claim.id,
            identifier: SecureRandom.uuid)

          @contention_details = ContentionDetail.create(
            contention_id: @contention.id,
            description: params[:contention_description],
            active: true,
            name: params[:contention_name])
        end

        triage_users = User.get_triage_users_by_site(params[:site_id])
        if triage_users.present?
          triage_users.each do |key, value|
            puts "Sending email to ::: " + key["email"]
            @user = User.find_by_id(key["id"])
            @user.email = "cui.testing@gmail.com"
            #cs UserMailer.send_create_exam_request_email(@user).deliver_now
          end
        end
        redirect_to new_exam_request_path
      else
        @claim = Claim.new
        @contentions = @claim.contentions + [Contention.new]
        @all_sites = Site.all
        if @all_sites.present?
          @sites = @all_sites.map{ |s| [s.name, s.id] }
        end
        flash.now[:alert] = "Please enter values for all required fields."
        render action: :new
      end
    elsif
      redirect_to dashboards_path
    end
   end
  end

  def create_exams

  end

  def change_site
  end

  private

  def get_exam_request
    @exam_request = ExamRequest.find_by_identifier(params[:id])
  end

  def get_exam_request_using_er_id
    @exam_request = ExamRequest.find_by_identifier(params[:er_id])
  end

  def redirect_if_no_exam_request
    if @exam_request.nil?
      flash[:alert] = "Unable to locate the Exam Request record."
      redirect_to dashboards_path
    end
  end

  def addExamHistory(selectedContentionIds, examRequest)
    notes = current_user.first_name + " " + current_user.last_name + " created an examination for"
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      notes = notes + separator + contention.contention_details[0].name
    end
    @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @exam_request_history.save
  end

  def addExaminationHistory(selectedContentionIds, examination)
    notes = current_user.first_name + " " + current_user.last_name + " created the examination for"
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      notes = notes + separator + contention.contention_details[0].name
    end
    @examination_history = ExaminationHistory.new(examination_id: examination.id, notes: notes)
    @examination_history.save
  end
end
