class DmAssignmentsController < ApplicationController
  include DataTablePaginator
  include ContentManagerHelper
  before_action :set_dm_assignment, only: [:create, :show, :edit, :update, :destroy]

  # GET /diagnosis_modifiers
  # GET /diagnosis_modifiers.json
  def index
  end

  # GET /diagnosis_modifiers/1
  # GET /diagnosis_modifiers/1.json
  def show
    if params[:delete_diagnosis_id].present?
      d = @diagnosis_modifier.diagnoses.find_by_id(params[:delete_diagnosis_id])
      @diagnosis_modifier.diagnoses.delete(d)
      flash.now[:notice] = "Diagnosis successfully removed."
    end
  end

  # GET /diagnosis_modifiers/new
  def new
    @dm_assignment = DmAssignment.new
    @diagnosis = Diagnosis.find(params[:diagnosis_id])
    @diagnosis_modifier = DiagnosisModifier.find(params[:diagnosis_modifier_id])
  end

  # GET /diagnosis_modifiers/1/edit
  def edit
    if params[:delete_diagnosis_id].present?
      d = @diagnosis_modifier.diagnoses.find_by_id(params[:delete_diagnosis_id])
      @diagnosis_modifier.diagnoses.delete(d)
      flash.now[:notice] = "Diagnosis successfully removed."
    end
  end

  # POST /dm_assignments/1/negative_show_check
  # Handles ajax call when user clicks on check boxes on the diagnoses/id/edit page.
  def negative_show_check
    if dm = DmAssignment.find(params[:id])
      @diagnosis = Diagnosis.find(params[:diagnosis_id])
      params[:state] == "Yes" ? dm.negative_show = false : dm.negative_show = true
      dm.save   
      respond_to do |format|        
        format.js {}
      end      
    end        
  end  

  # POST /diagnosis_modifiers
  # POST /diagnosis_modifiers.json
  def create
    @dm_assignment = DmAssignment.new(dm_assignment_params)

    respond_to do |format|
      if @dm_assignment.save
        update_dm_assignment_associations
        format.html { redirect_to [@diagnosis, @diagnosis_modifier, @dm_assignment], notice: 'New DM Assignment successfully added.' }
        format.json { render action: 'show', status: :created, location: diagnosis_diagnosis_modifier_dm_assignment_path(@diagnosis, @diagnosis_modifier, @dm_assignment) }
      else
        format.html { render action: 'new' }
        format.json { render json: @dm_assignment.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /diagnosis_modifiers/1
  # PATCH/PUT /diagnosis_modifiers/1.json
  def update
    respond_to do |format|
      if @dm_assignment.update(dm_assignment_params)
        format.html {
          if params[:dm_assignment][:prev_url]
            redirect_to params[:dm_assignment][:prev_url], notice: 'DM Assignment successfully updated.'
          else
            redirect_to edit_diagnosis_diagnosis_modifier_dm_assignment_path(@dm_assignment.get_diagnosis, @dm_assignment.get_diagnosis_modifier, @dm_assignment), notice: 'DM Assignment successfully updated.'
          end
        }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @dm_assignment.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /diagnosis_modifiers/1
  # DELETE /diagnosis_modifiers/1.json
  def destroy
    @dm_assignment.destroy
    respond_to do |format|
      format.html { redirect_to :back }
      format.json { head :no_content }
    end
  end

  def paged_list
    dm_assignment_to_fields_func = -> (dm_assignment) do
      diagnosis = dm_assignment.get_diagnosis
      diagnosis_modifier = dm_assignment.get_diagnosis_modifier
      {
        id:                       dm_assignment.id,
        name:                     dm_assignment.name.try(:humanize),
        row_label:                dm_assignment.label.try(:humanize),
        dma_diagnosis:            diagnosis.name.try(:humanize),
        dma_diagnosis_modifier:   diagnosis_modifier.name.try(:humanize),
        edit:                     edit_diagnosis_diagnosis_modifier_dm_assignment_path(diagnosis, diagnosis_modifier, dm_assignment),
        destroy:                  diagnosis_diagnosis_modifier_dm_assignment_path(diagnosis, diagnosis_modifier, dm_assignment)
      }
    end
    ordered_dm_assignments = apply_ordering_to_query(DmAssignment.filter(params), DmAssignment::FIELDS_FOR_RESULTSET, params['order'])

    json_user_data = paginate_with_params(ordered_dm_assignments).includes(:diagnosis, :diagnosis_modifier).map {|u| dm_assignment_to_fields_func.call(u) }
    total_record_count = ordered_dm_assignments.count
    render json: {
      draw: params[:draw].to_i,
      recordsTotal: total_record_count,
      recordsFiltered: total_record_count,
      data: json_user_data
    }
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_dm_assignment
      @dm_assignment = (DmAssignment.find(params[:id]) rescue nil)
      @diagnosis = Diagnosis.find(params[:diagnosis_id])
      @diagnosis_modifier = DiagnosisModifier.find(params[:diagnosis_modifier_id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def dm_assignment_params
      params.require(:dm_assignment).permit(:label, :negative_show, :exam_response_fields)
    end

    def update_dm_assignment_associations
      @dm_assignment.diagnosis = @diagnosis
      @dm_assignment.diagnosis_modifier = @diagnosis_modifier
      @dm_assignment.save
    end
end
