class DiagnosesController < ApplicationController
  include DataTablePaginator
  before_action :set_diagnosis, only: [:show, :edit, :update, :destroy, :sort]
  before_action :check_for_identifier_params, only: :update

  # GET /diagnoses
  # GET /diagnoses.json
  def index
  end

  # GET /diagnoses/1
  # GET /diagnoses/1.json
  def show
  end

  # GET /diagnoses/new
  def new
    @diagnosis = Diagnosis.new
  end

  # GET /diagnoses/1/edit
  def edit
    if params[:delete_diagnosis_modifier_id].present?
      dm = @diagnosis.diagnosis_modifiers.find_by_id(params[:delete_diagnosis_modifier_id])
      @diagnosis.diagnosis_modifiers.delete(dm)
      flash.now[:notice] = "Diagnosis Modifier successfully removed."
    end
    @diagnosis_modifiers_not_yet_added = DiagnosisModifier.all.order("name ASC")
    @generated_html = @diagnosis.build_html()
  end

  # POST /diagnoses
  # POST /diagnoses.json
  def create
    @diagnosis = Diagnosis.new(diagnosis_params)

    respond_to do |format|
      if @diagnosis.save
        format.html { redirect_to @diagnosis, notice: 'Diagnosis was successfully created.' }
        format.json { render action: 'show', status: :created, location: @diagnosis }
      else
        format.html { render action: 'new' }
        format.json { render json: @diagnosis.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /diagnoses/1
  # PATCH/PUT /diagnoses/1.json
  def update
    respond_to do |format|
      orig_diagnosis_name = @diagnosis.name
      if @diagnosis.update(diagnosis_params)
        if params[:diagnosis] && params[:diagnosis][:diagnosis_modifier_ids]
          params[:diagnosis][:diagnosis_modifier_ids].each do |dm|
            diagnosis_mod = DiagnosisModifier.find_by_id(dm)
            if diagnosis_mod
              @diagnosis.diagnosis_modifiers << diagnosis_mod
            end
          end
        end
        @diagnosis.save
        @diagnosis.update_dma_names if orig_diagnosis_name != @diagnosis.name
        format.html { redirect_to edit_diagnosis_path(@diagnosis), notice: 'Diagnosis was successfully updated.' }
        format.json { head :no_content }
      else
        format.html {
          @diagnosis_modifiers_not_yet_added = DiagnosisModifier.all.order("name ASC")
          @generated_html = @diagnosis.build_html()
          render action: 'edit'
        }
        format.json { render json: @diagnosis.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /diagnoses/1
  # DELETE /diagnoses/1.json
  def destroy
    @diagnosis.destroy
    respond_to do |format|
      format.html { redirect_to diagnoses_url }
      format.json { head :no_content }
    end
  end

  def paged_list
    diagnosis_to_fields_func = -> (diagnosis) do
      {
        id:                 diagnosis.id,
        name:               diagnosis.name.try(:humanize),
        row_label:          diagnosis.label.try(:humanize),
        code:               diagnosis.code,
        edit:               edit_diagnosis_path(diagnosis),
        destroy:            diagnosis_path(diagnosis)
      }
    end

    ordered_diagnoses =  apply_ordering_to_query(Diagnosis.filter(params), Diagnosis::FIELDS_FOR_RESULTSET, params['order'])
    return_data = datatables_json_for_query_using_func(
      ordered_diagnoses, diagnosis_to_fields_func
    )
    render json: return_data
  end

  def sort
    params[:dm_assignment].each_with_index do |id, index|
      @diagnosis.dm_assignments.where(id: id).update_all({position: index+1})
    end
    render nothing: true
  end


  private
    # Use callbacks to share common setup or constraints between actions.
    def set_diagnosis
      @diagnosis = Diagnosis.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def diagnosis_params
      params.require(:diagnosis).permit(:name, :label, :code)
    end

    def check_for_identifier_params
      if params[:identifier].present?
        redirect_to edit_diagnosis_path(@diagnosis, :identifier => params[:identifier])
      end
    end
end
