class DashboardsController < ApplicationController
  include ExamRequestStateHelper, ExaminationStateHelper, DataTablePaginator
  #before_action :set_dashboard, only: [:show, :edit, :update, :destroy]
  skip_before_action :clear_current_site, except: [:index]
  check_authorization
  authorize_resource

  # GET /dashboards
  # GET /dashboards.json
  def index
    @dashboards = Dashboard.all
    #@examinations = Examination.all
    if current_user
      @auth_state = current_user.authorization_state
      @user = current_user
      if @auth_state == "authorized"


        #ALERTS
        @user_alerts = @user.is_app_admin? ? Alert.active : []

        #TRIAGE USER EXAMINATIONS
        if current_user.has_this_role_on_any_site? "Triage"

          @my_triage_sites = @user.sites.site_role_triage
          #@examinations = get_examinations('triage', ExaminationStateHelper::SCHEDULED)
          @cancelled_examinations_for_triage_user = @my_triage_sites.map {|n| n.examinations.includes(:examination_state)}.flatten.select{|ex| (ex.examination_state.code == "CANCELLED" && ex.clinician.nil? && !ex.acknowledged) }
          @pending_exams = get_examinations('triage', 'PENDING') + @cancelled_examinations_for_triage_user
          @cancelled_exam_requests_pending_ack = @my_triage_sites.map {|n| n.exam_requests.includes(:exam_request_state)}.flatten.select{|ex| (ex.exam_request_state.code == "CANCELLED" && !ex.cancellation_acknowledged)}
#          @exam_requests = @my_triage_sites.map {|n| n.exam_requests}.flatten.select{|ex| ex.exam_request_state.code == ExamRequestStateHelper::IN_PROGRESS} + @cancelled_exam_requests_pending_ack
        #exams = sites_with_my_role.map {|n| n.examinations}.flatten.select{|ex| ex.examination_state == ex_state}

          @cancelled_exam_requests = @my_triage_sites.map {|n| n.exam_requests}.flatten.select{|ex| (ex.exam_request_state.code == "CANCELLED" && ex.cancellation_acknowledged) }

          @cancelled_examinations = @my_triage_sites.map {|n| n.examinations}.flatten.select{|ex| (ex.examination_state.code == "CANCELLED" && (ex.acknowledged or ex.clinician_acknowledged)) }
        end

        #SCHEDULER USER EXAMINATIONS
        if current_user.has_this_role_on_any_site? "Scheduling"
          @my_scheduler_sites = @user.sites.site_role_scheduling
          @cancelled_examinations_for_scheduler_user = @my_scheduler_sites.map {|n| n.examinations}.flatten.select{|ex| (ex.examination_state.code == "CANCELLED" && ex.exam_date.nil? && ex.clinician != nil && !ex.acknowledged) }
          @ready_sched_exams = get_examinations('scheduling', 'READY_TO_BE_SCHEDULED') + @cancelled_examinations_for_scheduler_user + get_examinations('scheduling', ExaminationStateHelper::RESCHEDULE)

        end

        #CLINICIAN USER EXAMINATIONS
        if current_user.has_this_role_on_any_site? "Clinician"
          @my_clinician_sites = @user.sites.site_role_clinician
          @cancelled_examinations_for_clinician_user = @my_clinician_sites.map {|n| n.examinations.includes(:examination_schedules)}
                                                          .flatten.select{|ex| (ex.examination_schedules
                                                          .flatten.select{|es| es.active == true } &&
                                                          ex.examination_state.code == "CANCELLED" &&
                                                          ex.clinician != nil &&
                                                          !ex.clinician_acknowledged) }
          @clinician_exams = get_examinations('clinician', 'SCHEDULED') + get_examinations('clinician', 'IN_PROGRESS') + @cancelled_examinations_for_clinician_user
          @clinician_other_exams = get_clinician_other_examinations() + get_examinations('clinician', ExaminationStateHelper::RESCHEDULE)
        end

        if current_user.has_this_role_on_any_site? "Supervisory Clinician"
          @all_ready_for_review_exams = get_examinations('super_clinician', 'COMPLETED')
          @my_supervised_exams = @user.my_supervised_exams(@all_ready_for_review_exams)
          @reviewed_superv_clinician_exams = get_examinations('super_clinician', 'REVIEWED')

        end
        if current_user.has_this_role_on_any_site? "Quality Assurance"
          @reviewed_qa_exams = get_examinations('qa', 'REVIEWED')
        end

      else
        #sign_out current_user
        #flash.clear
        flash.now[:alert] = "You do not currently have access to the CUI system."
      end
    end

    #appointmentScheduledEvent = AppointmentScheduledEvent.new
    #appointmentScheduledEvent.build_notification("171", "248", "6")
    #VlerDASJob.sendNotification(appointmentScheduledEvent)

  end

  def get_exam_requests
    exam_requests_to_fields_func = -> (exam_request) do
      {
        id:                 exam_request.id,
        identifier:         exam_request.identifier,
        date_created:       exam_request.created_at.strftime('%F'),
        status:             exam_request.exam_request_state.name,
        veteran_name:       "#{exam_request.claim.first_name} #{exam_request.claim.last_name}",
        file_number:        exam_request.claim.file_number,
        associated_site:    exam_request.site.name
      }
    end

    @my_triage_sites = current_user.sites.site_role_triage
    if @my_triage_sites != nil
      siteStr = ""
      @my_triage_sites.each do |s|
        siteStr += "'" + s.name + "',"
      end
      siteStr = siteStr[0, siteStr.length-1]
      @exam_requests = ExamRequest.joins(:site).where("sites.name IN (" + siteStr + ")").includes(:exam_request_state, :claim, :site)
    end
    #@exam_requests = ExamRequest.joins(:site).where("sites.name = 'QTC'")
    #@my_triage_sites.map {|n| n.exam_requests}.flatten.select{|ex| ex.exam_request_state.code == ExamRequestStateHelper::IN_PROGRESS}

    render json: datatables_json_for_query_using_func(
      @exam_requests, exam_requests_to_fields_func
    )
  end

  def set_site
    if params[:my_site_select] && params[:my_site_select][:id]
      $current_site = Site.find params[:my_site_select][:id]
      $current_site_roles = current_user.get_site_roles($current_site)
      flash[:notice] = "Your current working site has been set to: " + $current_site.name
      redirect_to claims_path
    end
  end

  def take_action
    @examination = Examination.find_by_id(params[:id])
    @sites = Site.all
  end

  def execute_statement(sql)
    results = ActiveRecord::Base.connection.exec_query(sql)
    results.present? ? results : nil
  end

  # GET /dashboards/1
  # GET /dashboards/1.json
  def show
  end

  # GET /dashboards/new
  def new
    @dashboard = Dashboard.new
  end

  # GET /dashboards/1/edit
  def edit
  end

  # POST /dashboards
  # POST /dashboards.json
  def create
    @dashboard = Dashboard.new(dashboard_params)

    respond_to do |format|
      if @dashboard.save
        format.html { redirect_to @dashboard, notice: 'Dashboard was successfully created.' }
        format.json { render action: 'show', status: :created, location: @dashboard }
      else
        format.html { render action: 'new' }
        format.json { render json: @dashboard.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /dashboards/1
  # PATCH/PUT /dashboards/1.json
  def update
    respond_to do |format|
      if @dashboard.update(dashboard_params)
        format.html { redirect_to @dashboard, notice: 'Dashboard was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @dashboard.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /dashboards/1
  # DELETE /dashboards/1.json
  def destroy
    @dashboard.destroy
    respond_to do |format|
      format.html { redirect_to dashboards_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_dashboard
      @dashboard = Dashboard.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def dashboard_params
      params[:dashboard]
    end

    def get_clinician_other_examinations()
      ex_state_sch = ExaminationState.find_by_code(ExaminationStateHelper::SCHEDULED)
      ex_state_ip = ExaminationState.find_by_code(ExaminationStateHelper::IN_PROGRESS)
      sites_with_my_role = current_user.sites.where(:site_role_sets => {clinician: "true"})

      if sites_with_my_role.present?
        exams = sites_with_my_role.map {|n| n.examinations}.flatten.select{|ex| (ex.clinician == current_user.id and ex.examination_state_id != ex_state_sch.id and ex.examination_state_id != ex_state_ip.id)}
        return exams
      else
        return []
      end
    end

    # Get the examinations based on the provided user role and exam state.
    def get_examinations(role, exam_state)
      ex_state = ExaminationState.find_by_code(exam_state)
    #  sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {"#{role}": "true"})
      if role == "admin"
        sites_with_my_role = current_user.sites.site_role_admin
      elsif role == "triage"
        sites_with_my_role = current_user.sites.site_role_triage
      elsif role == "scheduling"
        sites_with_my_role = current_user.sites.site_role_scheduling
      elsif role == "clinician"
        sites_with_my_role = current_user.sites.site_role_clinician
      elsif role == "super_clinician"
        sites_with_my_role = current_user.sites.site_role_super_clinician
      elsif role == "qa"
        sites_with_my_role = current_user.sites.site_role_qa
      end
      if sites_with_my_role.present?
        exams = sites_with_my_role.map {|n| n.examinations.includes(:examination_state, :contentions)}.flatten.select{|ex| ex.examination_state == ex_state}
        return exams
      else
        return []
      end
    end
end
