require 'csv'
module InsufficientExamReportGenerator
  def write_line str
    @f += str + "\n"
  end

  def write_header start_date, end_date
    write_line "Detailed Insufficient Exam Report".center(100)
    write_line "For Date Range: #{start_date.strftime("%m/%d/%Y")} to #{end_date.strftime("%m/%d/%Y")}".center(100)
  end

  def header_break
    write_line "\n\n"
  end

  def internal_break
    write_line "\n"
  end

  def write_rework_reason con
    con[:rework_reason_list].each do |reason|
      write_line "Rework Reason: #{reason}"
    end
  end

  def write_contention_description con
    write_line "Contention Description: #{con[:contention_description]}"
  end

  def write_patient_info_and_claim_number con
    write_line "Patient Name:".ljust(30) + "SSN:".ljust(30) + "Claim #:"
    write_line con[:patient_name].truncate(15).ljust(30) + con[:patient_ssn].truncate(15).ljust(30) + con[:vbms_claim_id]
  end

  def write_examinations con
    write_line "Examination:".ljust(50) + "Provider:".ljust(50) + "Exam Date:"
    con[:previous_contention_exams].each do |exam|
      write_line exam[:title].ljust(50) + exam[:provider].ljust(50) + exam[:exam_date]
    end
  end

  def write_claim_type con
    write_line "".ljust(10) + "Claim Type: " + con[:benefit_type]
  end

  def write_priority_of_exam con
    write_line "".ljust(10) + "Special Considerations: "
    con[:special_issues].each do |issue|
      write_line "".ljust(16) + issue.to_s
    end
  end

  def write_rework_reason_free_text con
    con[:rework_reason_free_text_list].each do |reason|
      write_line "Rework Reason Free Text: "+reason
    end
  end

  def generate_insufficient_exam_report con_array, start_date, end_date
    @f = ""
    write_header start_date, end_date
    header_break
    
    con_array.each do |con|
      write_rework_reason con
      write_rework_reason_free_text con
      internal_break
      write_patient_info_and_claim_number con
      internal_break
      write_contention_description con
      write_examinations con
      write_claim_type con
      write_priority_of_exam con
      header_break
    end
    @f
  end

  def csv_header
    %w( Exam\ Date Patient\ Name Patient\ SSN Claim\ Number Claim\ Type Exam\ Special\ Considerations
     Contention\ Description Exam\ Info Rework\ Reasons Rework\ Reason\ Free\ Text)
  end

  def csv_attr_keys
    [:exam_date, :patient_name, :patient_ssn, :vbms_claim_id, :benefit_type, :special_issues, :contention_description, :previous_contention_exams, :rework_reason_list, :rework_reason_free_text_list]
  end

  def generate_insufficient_exam_report_csv con_array
    CSV.generate do |csv|
      csv << csv_header

      con_array.each do |record|
        csv << csv_attr_keys.map do |key|
          case key
          when :special_issues, :rework_reason_list, :rework_reason_free_text_list
            record[key].join("/")
          when :previous_contention_exams
            str = ""
            record[key].each do |info|
              str += info.values.join("/")+":"
            end
            str.chop
          else
            record.send(:[], key)
          end
        end
      end
    end
  end

end
