class ClaimsController < ApplicationController
  check_authorization only: [:new, :create, :show]
  skip_authorization_check only: [:index]
  skip_before_action :clear_current_site


  def index
    @claims = current_user.has_roles?(["medical_assistant", "supervisor"]) ? Claim.where("created_at > ?", 'April 10 2016') : current_user.incomplete_claims
    @reviewable_contentions = Contention.reviewable
  end

  def new
    @claim = Claim.new
    authorize! :new, @claim
    @contentions = @claim.contentions + [Contention.new]
  end

  def create
    @claim = Claim.new(claim_params)
    authorize! :create, @claim
    if @claim.save
      flash[:notice] = "Claim created."
      redirect_to @claim
    else
      error_messages = @claim.errors.full_messages.join(" ")
      render :new
    end
  end

  def show
    @claim = Claim.find(params[:id])
    authorize! :show, @claim
  end

  def details
    @claim = Claim.find(params[:id])
    @exam_request_data = @claim.exam_request_data
  end

  private

  def claim_params
    params.require(:claim).permit(:first_name, :middle_name, :last_name,
                                  :date_of_birth, :patient_ssn, :file_number,
                                  :facility_name, :facility_number,
                                  :contentions_attributes => [:name])
  end
end
