
class ApplicationController < ActionController::Base
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  # skip_before_action: verify_authenticity_token, only: saml
  protect_from_forgery with: :exception  #DOM-133, this must be on to mitigate CSRF via WASA finding
  before_filter :authenticate_user_and_handle_cookies
  before_action :configure_permitted_parameters, if: :devise_controller?
  before_action :clear_current_site
  skip_before_action :clear_current_site, only: [:pingserver]
  before_action :jump_to
  before_action :protect_from_host_header_attack

  def protect_from_host_header_attack
    env['HTTP_HOST'] = default_url_options.fetch(:host, env['HTTP_HOST'])
  end

  # handle two before_filter methods in sequence:
  # 1. authenticate user using devise
  # 2. after authentication, if successful: perform timezone check and
  # set timezone if preferences value does not match.
  def authenticate_user_and_handle_cookies
    authenticate_user!
    if current_user.present?
      current_user.create_preferences_if_empty
      # set timezone in preferences to match user session cookie
      timezone_from_browser = cookies['browser.timezone']
      if timezone_from_browser.present? && current_user.present?
        if timezone_from_browser != current_user.user_preference.time_zone
          current_user.user_preference.time_zone = timezone_from_browser
          current_user.user_preference.save!
        end
      end
    end
  end

  rescue_from CanCan::AccessDenied do |exception|
    Rails.logger.debug "Access denied on #{exception.action} #{exception.subject.inspect}"

    if current_user.is_cpp_user?
      redirect_to referrals_url, alert: exception.message
    else
      redirect_to root_path, alert: exception.message
    end
  end

  # rescue_from ActiveRecord::RecordNotFound do |exception|
  #   redirect_to root_path, alert: "Record not found, or you do not have access to that record."
  # end

  def pingserver
    return true;
    #nothing
  end

  def ssoi_method
  end

  def ssoe_method
  end

  def login
    login_method = case true
      when current_user.is_cpp_user?
        JUMP_TO_CONFIG[current_user.is_non_vha? ? 'non_vha' : 'vha_cc'].select{|x| x["URL"] == params[:jump_to_select]}.first["login"]
      when current_user.is_cui_user?
        JUMP_TO_CONFIG['cui_user'].select{|x| x["URL"] == params[:jump_to_select]}.first["login"]
      end
    params[:jump_to_select] = root_url.to_s + params[:jump_to_select] if current_user.is_cui_user?
    if params[:jump_to_select] =~ URI::regexp
      begin
        response = HTTPI.get(params[:jump_to_select])
        case login_method
          when 'none'
              redirect_to(params[:jump_to_select])
          when 'ssoi'
            redirect_to :back, alert: "SSOI capability is under development"
            #ssoi_method
          when 'ssoe'
            redirect_to :back, alert: "SSOE capability is under development"
            #ssoe_method
        else
          #login error
        end
      rescue
        redirect_to :back, alert: "Website is not responding. Please try again later"
      end
    else
      redirect_to :back, alert: "Please try again later"
    end
  end

  def get_veteran_by_ssn
    @veteran = Veteran.find_by_ssn(params[:ssn]);
    respond_to do |format|
      format.json { render json: @veteran}
    end
  end

  # Get list of facilities corresponding to VISN id passed in.
  # SMELL: This method is specific to the VISN resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_facilities
    visn = Visn.find(params[:id])
    @facilities = visn.facilities
    respond_to do |format|
      format.json { render json: @facilities}
    end
  end

  # Get list of providers corresponding to facility id passed in.
  # SMELL: This method is specific to the Facility resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_providers
    facilities = Facility.find(params[:id])
    @providers = facilities.providers
    respond_to do |format|
      format.json { render json: @providers}
    end
  end

  # Get list of providers corresponding to VISN id passed in.
  # SMELL: This method is specific to the VISN resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_providers_without_facility
    @providers = Provider.includes(:facility).where('facilities.visn_id = ?', params[:id]).references(:facilities)
    respond_to do |format|
      format.json { render json: @providers}
    end
  end

  def home
    if current_user.is_cpp_user?
      redirect_to referrals_path
    else
      redirect_to '/landing/index'
    end
  end

  protected

  def configure_permitted_parameters
    devise_parameter_sanitizer.for(:sign_up) << :first_name
    devise_parameter_sanitizer.for(:sign_up) << :last_name
  end

  private

  def jump_to
    if current_user
      # SMELL: perfomance impact.  See http://midwire.github.io/blog/2011/08/26/ruby-performance-case-vs-if-elsif/
      @options_jump_to = case true
      when current_user.is_cpp_user?
        JUMP_TO_CONFIG[current_user.is_non_vha? ? 'non_vha' : 'vha_cc'].collect{|x| [x["title"],x["URL"]]}
      when current_user.is_cui_user?
        JUMP_TO_CONFIG['cui_user'].collect{|x| [x["title"],x["URL"]]}
      end
    end
  end

  def assign_claim
    @claim = Claim.find(params[:claim_id])
  end

  def clear_current_site
    $current_site = nil
    $current_site_roles = nil
  end
end
