class Api::V1::ClaimsController < ActionController::Base
  include ExamRequestHelper, ContentionHelper, AppointmentHelper, ClarificationHelper  
  def create
    exam_request_xml = request.body.read
    begin
      #performInitialCheck(exam_request_xml)

      notificationDoc  = Nokogiri::XML(exam_request_xml)
      notificationType = XmlHelper.getContentType(notificationDoc)

      exam_request_hash = Hash.from_xml(exam_request_xml)
      
      #examManagementEventNotification = exam_request_hash.try(:[], 'feed').try(:[], 'entry').try(:[], 'content').try(:[], 'ExamManagementEventNotification')
      if notificationType == 'ExamSchedulingRequestCreatedEvent'
        processExamSchedulingRequestCreatedEvent(exam_request_xml, exam_request_hash)
        #ExamRequestHelper.delay.createRequestObject(exam_request_xml)
        render :json => "Request to process ExamManagementEventNotification received", status: 200
      elsif notificationType == 'ContentionCancellationRequestedEvent'
        processCancellationRequest(notificationDoc)
        render :json => "Request to process ContentionCancellationRequestedEvent received", status: 200
      elsif notificationType == 'AppointmentCancelRequestEvent'
        processAppointmentCancelRequestEvent(notificationDoc)
        render :json => "AppointmentCancelRequestEvent successfully received"
      elsif notificationType == 'ExamSchedulingRequestCancellationEvent'
        processExamSchedulingRequestCancellationEvent(notificationDoc)
        render :json => "ExamSchedulingRequestCancellationEvent successfully received"
      elsif notificationType == 'RescheduleRequestEvent'
        processRescheduleRequestEvent(notificationDoc)
        render :json => "RescheduleRequestEvent successfully received"
      elsif notificationType == 'ClarificationResponseEvent'
        processClarificationResponseEvent(notificationDoc)
        render :json => "ClarificationResponseEvent successfully received"
      elsif notificationType == 'ReworkedExamSchedulingRequestCreatedEvent'
        process_reworked_exam_scheduling_request_created_event(exam_request_xml, exam_request_hash)
        render :json => "ReworkedExamSchedulingRequestCreatedEvent successfully received"
      else
        render :json => "Invalid request"
      end
    rescue Exception => e
      render :json => "Invalid request: " + e.message
    end
  end



  def performInitialCheck(notification_xml)
    notificationXml = ExamManagementNotification.find_by_xml(notification_xml)
    if (notificationXml != nil)
      raise Exception, "Duplicate ExamManagement notification."
      return false
    elsif
      #save the notification
      ExamManagementNotification.create(xml: notification_xml)
      return true
    end
    return false
  end
  
  
end
