class Admin::EvaluationSpecsController < ApplicationController
  before_filter :assign_evaluation_spec, only: [:show, :edit, :update, :delete]

  def index
    @specs = EvaluationSpec.active_exams
  end

  def new
    @spec = EvaluationSpec.new
  end

  def create
    @spec = EvaluationSpec.new(evaluation_spec_params)
    if @spec.save
      flash[:notice] = "Successfully added spec: #{@spec.title}"
      redirect_to admin_evaluation_specs_path
    else
      flash[:alert] = "Error creating spec: #{@spec.errors.full_messages[0][0..75]}"
      render :new
    end
  end

  def show
  end

  def edit
    #This view can be rendered from various contexts for which evaluatiobn_spec form data might vary. Sometimes we want the updated data, other times the saved data. We add instance vars to facilitate this.
    @spec_data = @spec.spec
    @spec_title = @spec.title
    flash[:notice] = "Editing the evaluation spec for #{@spec.title}"
  end

  def update
    #Hang onto the previously saved evaluation_spec. It might be required in a view.
    @spec = EvaluationSpec.find(params[:id])

    if params[:commit] == 'Preview' #Preview was pressed
      begin
        @form = FML::Form.new(params[:evaluation_spec][:spec])
        @spec_data = Base64.encode64(params[:evaluation_spec][:spec])
        flash[:notice] = "Previewing the evaluation spec for #{@form.title}"
        render :preview
      rescue FML::InvalidSpec => error
        #We need the invalid data so user can see the mistakes
        @spec_data = params[:evaluation_spec][:spec]
        @spec_title = @spec.title
        @spec.errors.add(:base, error.to_s)
        flash.now[:alert] = "Invalid Spec: #{error.message[0..75]}"
        render :edit
      end

    elsif params[:commit] == 'Back to Edit' #Back to Edit was pressed from preview mode
      @spec_id = params[:id]
      #Base64.decode64 to prevent HAML additional indentation
      @spec_data = Base64.decode64(params[:evaluation_spec][:spec])
      @form = FML::Form.new(@spec_data)
      @spec_title = @form.title
      flash[:notice] = "Editing the evaluation spec for #{@form.title}"
      render :edit

    elsif params[:commit] =~ /Save/ #Save was pressed, either from edit or from preview
      @spec_data = evaluation_spec_params[:spec]

      #Base64.decode64 to prevent HAML additional indentation if here from preview
      @spec_data = Base64.decode64(@spec_data) if params[:evaluation_spec]["save_from"] == "preview"
      if @spec.update_attributes(spec: @spec_data)
        flash[:notice] = "Successfully updated #{@spec.title}"
        redirect_to action: :show
      else
        @spec_title = @spec.title
        flash.now[:alert] = "Error updating spec: #{@spec.errors.full_messages[0][0..75]}"
        render :edit
      end
    end
  end

  def destroy
    @spec = EvaluationSpec.find(params[:id])
    @spec.delete
    flash[:notice] = "Successfully deleted #{@spec.title}"
    redirect_to admin_evaluation_specs_path
  end

  private

  def assign_evaluation_spec
    @spec = EvaluationSpec.find(params[:id])
  end

  def evaluation_spec_params
    params.require(:evaluation_spec).permit(:spec, "save_from")
  end
end
