// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
$(document).ready(function() {
  function getMinorSystemsHeaders() {
    return [
      {data: "name", targets: 0},
      {data: "row_label", targets: 1},
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'\"></a>";
        },
        targets: 2, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 3, searchable: false, orderable: false
      }
    ];
  };

  function getMinorReturnData() {
    var $inputTag = $("#minor-systems-index-data");
    if ($inputTag.length > 0)
      return JSON.parse($inputTag.val()).data
    else
      return [];
  }

  $("#minor-systems-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    data: getMinorReturnData(),
    columns: getMinorSystemsHeaders(),
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "edit td-data-center", "targets": [2]},
        {"className": "destroy td-data-center", "targets": [3]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  })

	$("form.edit_minor_system #minor_system_id").chosen({
	  placeholder_text_multiple: "Associate Diagnoses",
	  search_contains: true
	})

	$("form.symptoms #minor_system_id").chosen({
	  placeholder_text_multiple: "Associate Symptoms",
	  search_contains: true
	})

  $("form.general_questions #minor_system_id").chosen({
    placeholder_text_multiple: "Associate General Questions",
    search_contains: true
  })
});


