// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
$(function(){
  function getEvaluationTemplateHeaders() {
    return [
      {data: "name", render: function(data) {
          return "<span title='name'>"+data+"</a>";
        },
        targets: 0
      },
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 1, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 2, searchable: false, orderable: false
      }
    ];
  };

  $("#evaluation-templates-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getEvaluationTemplateHeaders(),
    ajax: '/evaluation_templates/paged_list',
    processing: true,
    serverSide: true,
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "edit td-data-center", "targets": [1]},
        {"className": "destroy td-data-center", "targets": [2]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

	$("[id$=-systems]").sortable({
		axis: 'y',
		update: function(event, ui) {
			$.ajax({
				type: "POST",
				url: $(this).data('update-url'),
				data:  $(this).sortable('serialize')
			});
		}
	});

	$("form.edit_evaluation_template #evaluation_template_id").chosen({
	  placeholder_text_multiple: "Associate Major Systems",
	  search_contains: true
	})
});
