// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function() {

  function getExamRequestHeaders() {
    var headers = [
      {title: "Date Created", data: "date_created", orderable: false},
      {title: "Status", data: "status", orderable: false},
      {title: "Veteran Name", data: "veteran_name", orderable: false},
      {title: "File Number", data: "file_number", orderable: false},
      {title: "Associated Site", data: "associated_site", orderable: false},
      {title: "",
       orderable: false,
       render: function( data, type, row ) {
          return '<a href="erp/view_exam_request/' + row.identifier + '" >Take action</a>';
       }
      }
    ];
    return headers;
  }

  var $examRequestTable = $('#examRequestsList').DataTable({
    columns: getExamRequestHeaders(),
    ajax: '/dashboards/get_exam_requests',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    bSort: true,
    bFilter: false,
    searching: false,
    pageLength: 10
  });

});


function showAlertDetails(alert_description, site, requester) {
    document.getElementById('alertDetailsModalId').style.display='none';
    document.getElementById('alertDetailsModalId').style.display='block';

    $("#alertDetails-details").html(alert_description);
    $("#alertDetails-site").html(site);
    $("#alertDetails-requester").html(requester);

    //Scroll to bottom of table
    var height = $("#alertDetailId").height();
    $("#alertDetailId").scrollTop(height);
}

var alertFlag = "show";
$("#alertHeaderId").click(function() {
  if(alertFlag == "show") {
    alertFlag = "hide"
    $("#alertHeaderId").html("+");
    $("#alertDetailId").hide();
  } else if(alertFlag == "hide") {
    alertFlag = "show"
    $("#alertHeaderId").html("--");
    $("#alertDetailId").show();
  }
});
