// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function() {

  /* get headers (title and data field binding) required by DataTables.
   * Header titles must match <thead> header names rendered in table.
   * Header data field names must match data from in Ajax JSON response. */
  function getHeaders() {
    var headers = [
      {title: "Name", data: "patient_name", orderable: true},
      {title: "SSN", data: "ssn", orderable: true},
      {title: "Episode of Care", data: "episode_of_care", orderable: true},
      {title: "Status", data: "status", orderable: true},
      {title: "Ordering Physician", data: "ordering_physician", orderable: false},
      {title: "Date", data: "date", orderable: true}
    ];
    return headers;
  }

  var $table = $('#consultationList').DataTable({
    columns: getHeaders(),
    ajax: '/consultations/paged_list',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    bSort: true,
    bFilter: false,
    searching: false,
    pageLength: 10
  });

  var AUTOCOMPLETE_MIN_LENGTH = 2;

  // Handles autocomplete functionality for Ordering Provider textbox
  $('form#consultationFilterForm #ordering_provider_text').autocomplete({
    source: function(request, response) {
      var facility_id = $("#facility_id_select").val();
      var visn_id = $("#visn_id_select").val();
      if ((facility_id === '') && (visn_id === '')) {
        $('#physicianSearchErrorMsg').show();
      }
      else {
        $('#physicianSearchErrorMsg').hide();
        $.ajax({
          url: '/consultations/physician_select',
          dataType: 'json',
          data: {
             term: request.term,
             facility_id: $("#facility_id_select").val(),
             visn_id: $("#visn_id_select").val()
          }
        }).done(function(data) {
          // invoke response callback to load dropdown list, with names only
          var dropdownData = $.map(data, function(val) {
            return {label: val.name, value: val.id};
          });
          response(dropdownData);
        });
      }
    },
    select: function(event, ui) {
      event.preventDefault();
      $('form#consultationFilterForm #ordering_provider_text').val(ui.item.label);
      $('form#consultationFilterForm #ordering_provider_id').val(ui.item.value);
    },
    minLength: AUTOCOMPLETE_MIN_LENGTH,
    delay: 200
  });

  $('form#consultationFilterForm #ordering_provider_text').on('change', function() {
    if ($(this).val().length < AUTOCOMPLETE_MIN_LENGTH) {
      $('form#consultationFilterForm #ordering_provider_id').val('');
    }
  });

  // add event handler for when user clicks on datatable row
  $('#consultationList tbody').on('click', 'tr', function () {
    var data = $table.row(this).data();
    if (!isNaN(parseInt(data.id))) {
      window.location = "consultations/" + parseInt(data.id);
    }
  });

  $('.date-field').datepicker();

  // Triggered when user changes NPI field
  $('.consultation-npi').change(function() {
    var npi = $(this).val();
    if (npi === '') {
      $.each($('input[data-fieldname]'), function(k, inputVal) {
        $(inputVal).prop('readonly', false).val('');
      });
    }
    else {
      $.getJSON('/providers/find_by_npi/' + npi)
        .done(function(data) {
          $.each($('input[data-fieldname]'), function(k, inputVal) {
            var fieldName = $(inputVal).data('fieldname');
            $(inputVal).prop('readonly', true).val(data[fieldName]);
          });
        })
        .fail(function(jqXHR) {
          $('#invalid-ssn').remove();
          $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid-ssn"> <div class="row"> <div class="small-12 columns">' +
            (jqXHR.responseJSON.error || 'Invalid NPI value.') + '</div> </div> </div>');
          window.scrollTo(0,0);
        });
    }
  });

  $(document).on("keypress", "form.new_consultation", function(event) {
      return event.keyCode != 13;
  });

  $(document).on('click', 'button#resetConsultFilterButton', function(e) {
    // perform form reset, then reset hidden form inputs separately.
    // (Hidden inputs don't reset as per W3C standards.)
    var $formElement = $('#consultationFilterForm');
    $formElement[0].reset();
    $formElement.find('input:hidden').val('');

    $("select#facility_id_select option").remove();
    $("select#physician_id_select option").remove();
    var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
    $(row).appendTo("select#facility_id_select");
    $(row).appendTo("select#physician_id_select");
    $.get('/reset_filter', function(data) {
      if (data.success) {
        $table.draw();
      }
      else {
        alert('Error clearing Consultation filtering preferences.  Consult the Help Desk for support.');
      }
    });
  });

  /* handle Filter button form action on top panel */
  $("form#consultationFilterForm").submit(function(e) {
    $.ajax({
      type: "POST",
      url: $(this).attr('action'),
      data: $(this).serialize() // serializes the form's elements.
    })
    .done(function(data) {
      if (data.success) {
        $table.draw();
      }
      else {
        alert('Error settting Consultation filtering preferences.  Consult the Help Desk for support.');
      }
    });
    e.preventDefault(); // avoid to execute the actual submit of the form.
  });

});
