// This is a manifest file that'll be compiled into application.js, which will include all the files
// listed below.
//
// Any JavaScript/Coffee file within this directory, lib/assets/javascripts, vendor/assets/javascripts,
// or vendor/assets/javascripts of plugins, if any, can be referenced here using a relative path.
//
// It's not advisable to add code directly here, but if you do, it'll appear at the bottom of the
// compiled file.
//
// Read Sprockets README (https://github.com/sstephenson/sprockets#sprockets-directives) for details
// about supported directives.
//
//= require jquery3
//= require jquery_ujs
//= require dataTables/jquery.dataTables
//= require jquery-ui
//= require jquery-ui/widgets/datepicker
//= require jquery-ui/widgets/autocomplete
//= require datetimepicker
//= require moment
//= require jquery.inputmask
//= require jquery-validator
//= require jquery-ui/widgets/sortable
//= require chosen
//= require foundation
//= require js.cookie
//= require jstz
//= require browser_timezone_rails/set_time_zone
//= require_tree .

//JQuery 3 fix. Allows "load" to work in gems that require it.
jQuery.fn.load = function(callback){
   $(window).on("load", callback)
};

$(function(){
  // Commented out the code below since the chosen() functionality
  // attached to these controls renders them out of compliance with 508
  // (The controls don't function properly at this time when a screen reader
  // running.  Thus we can't use this capability.)
  // note: 10/12/16 - john mcmanamon- reactivated the chosen functionalty
  // for the evaluation spec control below per user request.
  // This is temporary until a workaround can be found.
  $("#evaluation_evaluation_spec_id").chosen();
  //$("#user_id").chosen();
  //$("#site_select_id").chosen();
  //$("#site_selection_id").chosen();
  //$("#my_site_select_id").chosen();
  //$("#all_site_select_id").chosen();
  //
  function setDatepicker(id) {
    $(id).datepicker({
      selectOtherMonths: true,
      changeMonth: true,
      changeYear: true
    });
  }

  // 508 helper method that outputs message into a span
  // checks for a ctrl or cmd keypress plus arrow keys
  $('#examination_date').keydown(function(e) {
    var modifier = e.ctrlKey || e.metaKey
    if (modifier && e.keyCode >= 37 && e.keyCode <= 40) {
      var message = "" + $(".ui-state-hover").html() +
        " " + $(".ui-datepicker-month").html() +
        " " + $(".ui-datepicker-year").html();
      $('#liveRegion').html(message);
    }
  });

  setDatepicker("#examination_date");
  $("#veteran_birth_date").datepicker({
        selectOtherMonths: true,
        changeMonth: true,
        changeYear: true,
        defaultDate: new Date(1950,1)
      });
  setDatepicker("#elapsed_days");
  setDatepicker("#exam_request_start_date");
  setDatepicker("#exam_request_end_date");
  setDatepicker("#dates_");
  setDatepicker("#dates_e");

  $('#table_id').DataTable({
    "language": {
      "lengthMenu": "Display _MENU_ Records",
      "zeroRecords": "No records found",
      "info": "Showing page _PAGE_ of _PAGES_",
      "infoEmpty": "No records available",
      "infoFiltered": "(filtered from _MAX_ total records)"
    }
  });
  $("#ssn").inputmask("999-99-9999");

  // foundation has to be at the bottom of this function for some reason
  // it creates an issue with datepicker jquery
  $(document).foundation();
});


// ===== Scroll to Top ====
// The below code is added for 'Return to top' functionallty
$(window).scroll(function() {
  if ($(this).scrollTop() >= 50) {        // If page is scrolled more than 50px
      $('#return-to-top').fadeIn(200);    // Fade in the arrow
  } else {
      $('#return-to-top').fadeOut(200);   // Else fade out the arrow
  }
});

$('#return-to-top').click(function() {      // When arrow is clicked
  $('body,html').animate({
     scrollTop : 0                       // Scroll to top of body
   }, 500);

});

function pingServer() {
  // keep the server from timing out - called from application.html.haml
  $.ajax({
    type: "GET",
    url: "/pingserver",
    data: "",
    dataType: "",
   });
   // call again in 20 mins
   setTimeout(pingServer, 20*60*1000);

}

function resetTimer(){
   // clear any existing timeouts and setup timeout warning in 25 mins
   // this is called from application.html.haml on various windows actions
   clearTimeout(timeoutWarn);
   clearTimeout(timeoutExpire);
   timeoutWarn = setTimeout(warnTimeout, 25*60*1000);
}

function warnTimeout(){
    //set logout for 5 mins from now
    timeoutExpire = setTimeout(expireTimeout, 5*60*1000);
    var date = new Date();
    var time = date.toLocaleTimeString();
    // warn user of logout in 5 mins
    alert(time + "\nWarning: You will be logged out in 5 minutes due to inactivity.\nSelect 'Ok' and then press any key, or scroll, or click \nanywhere on the page to remain logged in.");
}

function expireTimeout(){
   alert("You have been logged out due to inactivity.\nSelect 'Ok' to be redirected to the Login page.");
   // mimic a click on the logout control
   document.getElementById("sign-out").click();
}


//!-- initialize a selector as an accessibleMegaMenu -->
$('nav').accessibleMegaMenu({
   /* prefix for generated unique id attributes, which are required
    *  to indicate aria-owns, aria-controls and aria-labelledby */

            uuidPrefix: "accessible-megamenu",

            /* css class used to define the megamenu styling */
            menuClass: "mm-nav-menu",

            /* css class for a top-level navigation item in the megamenu */
            topNavItemClass: "mm-nav-item",

            /* css class for a megamenu panel */
            panelClass: "mm-sub-nav",

            /* css class for a group of items within a megamenu panel */
            panelGroupClass: "mm-sub-nav-group",

            /* css class for the hover state */
            hoverClass: "hover",

            /* css class for the focus state */
            focusClass: "focus",

            /* css class for the open state */
            openClass: "open"
 });

$('.subnav').accessibleMegaMenu({
   /* prefix for generated unique id attributes, which are required
    *  to indicate aria-owns, aria-controls and aria-labelledby */

            uuidPrefix: "accessible-megamenu",

            /* css class for a top-level navigation item in the megamenu */
            topNavItemClass: "mm-sub-nav-item",

            /* css class for a megamenu panel */
            panelClass: "mm-sub-sub-nav",

            /* css class for the hover state */
            hoverClass: "hover",

            /* css class for the focus state */
            focusClass: "focus",

            /* css class for the open state */
            openClass: "open"
 });

$(".from_date").datepicker()
    .on('change', function(ev) {
        $(".to_date").datepicker('setDate', null);
        $(".to_date").datepicker("option", "minDate", this.value)
        $(".to_date").val($(".from_date").val())
    })

/* Feedback Form Alert Box */
function feedbackalert(){
  var feedbackalert = localStorage.getItem('feedbackalert') || '';
  if (feedbackalert != 'yes') {
   alert("Caution: Do not include any sensitive or classified information in feedback");
   localStorage.setItem('feedbackalert','yes');
  }
  $(window).on('beforeunload', function() {
    localStorage.setItem('feedbackalert','');
  });
}
