# Enterprise Veterans Self-Service - Clinician User Interface Application

The goal of EVSS is the integration of U.S. Department of Veterans Affairs (VA) web-based service portals into a combined platform with an aim to reduce costs and deliver a consistent user experience for veterans and veterans service organizations (VSOs).

As the steward for all VA’s information technology assets and resources, Office of Information and Technology (OIT) delivers available, adaptable, secure and cost-effective technology services to the VA. A crucially important element of the agency’s technology plan is the ability to enable convenient seamless interactions between the VA, veterans, service members, veterans service organizations, and the community of VA business partners and stakeholders providing services for the veteran. EVSS streamlines access by providing a fully functional and secure entry point to web-based systems for information and services accessed by, and on behalf of, veterans and the VA.

The Clinician User Interface (CUI) Application is a core component of the overall EVSS
system, and is composed of the two application components listed below:

## CUI DrTurboTax

This application provides a simple-to-use interface for VA Examiners evaluating
claims for disability benefits.

[ ![Codeship Status for adhocteam/DrTurbotax](https://codeship.com/projects/7b50aee0-f5bc-0132-df25-1ab904dbd922/status?branch=master)](https://codeship.com/projects/85844)

## Community Provider Portal

The Community Provider Portal (CPP) is a feature set build on top of the existing   
CUI application.  This feature set enables VHA Community Coordinators to create
patient consultation records and manage the consultation workflow, and enables
non-VHA health care providers to record medical data (appointment
scheduling, document, patient notes, etc.) for individual referral appointments.

## Installation and Setup

Before setting up the CUI application, make sure the following programs are installed:

* PostgreSQL, version 9.3 or higher (preferably version 9.6)
* Ruby 2.3.3, and core utility gems (`bundler`, `rake`, `json`, `rubygems-bundler`)
* Redis server, v3.2.8 or higher
* Highly recommended: A Ruby versioning system such as RVM or Rbenv

After making sure that Postgres and Ruby are properly installed, and cloning this
repository or pulling updates, perform the following to get the CUI Application up and running:

1. Run `bundle install` to install all dependency gems.

2. This project uses the `dotenv` gem to load environment variables,
  which are stored in the `.env` config file in the root directory.
  If you wish to customize the environment variables for your local environment,
  *do not change the default settings in .env*; instead create a `.env.local`
  file on the root level and put your environment variables there, which will
  override the default settings in `.env`.
  Notable environment variables that you may want to override are listed below:

  - `APP_URL`: the host domain/port exposed to the outside world.
  - `DEVELOPER_TESTING`: If set to **true**, CUI can display a banner to alert users that the environment they are working in is only for testing.
  - `DBHOST` and `DBPORT`: Hostname and port for the PostgreSQL server
  - `DBNAME`, `DBUSER`, `DBPASS`: Database name and username/password used for
  Postgres connection string.  Make sure that this user exists in the Postgres
  database and has superuser privileges before running the database migration
  or starting the app.
  - `ENABLE_OPENSSL_INITIALIZER`: Specifies whether to use a custom cipher suite,
  or use the system default.  Set to false if you wish to use your system-default
  truststore, or keep this set to true and set the `VLER_DAS_CIPHER_SUITES`
  accordingly. (See the "VLER DAS integration" section below for details.  Note that the default setting of **true** might throw the error
  ```
  OpenSSL::SSL::SSLError: SSL_CTX_set_cipher_list: no cipher match
  ```
  when first attempting to migrate the database, and if this occurs set `ENABLE_OPENSSL_INITIALIZER` to false to use your default SSL suite.)
  - `LOG_LEVEL`: Sets log level, with `debug` as default.

  There are many other environment variables for Puma configuration, email
  server configuration, HipChat and Slack automated feedback, SAML configuration,
  and other features listed below. (see: "VLER DAS integration",
  "SAML Configuration" sections below)  All system environment variables used
  by this application are documented in the file
  `doc/system_environment_variables.txt`.

3. (Optional) Run the following Rake commands to set up the database if you
  want to be safe and avoid using the auto-generated schema file:
  `rake db:create`, `rake db:migrate`,and `rake db:seed`.  

After the database has been configured, start up the Rails server with the
command `rake app:start` to start up all of the application components: the
Puma web server, Redis, and Sidekiq.  The command `rake app:stop` will stop
all of these components, and `rake app:restart` will stop and restart all
components with a time delay to make sure all components have stopped
before restarting.

## CUI DrTurboTax Additional Information

### CUI Evaluation Specs

The canonical version of the CUI Evaluation Specs can be found in the app/exams/ directory.  To load these into your database, run:

  `rake specs:sync`

This will update what is currently in your database with the latest version, as well as import any new specs.

To import specs from only a limited set of body systems, run:

  `rake specs:sync[Endocrine,Genitourinary,"Ear Diseases and Other Sense Organs"]`

### VBMS integration

CUI integrates with VBMS using an external application (https://github.com/adhocteam/connect_vbms).  CUI's integration with connect_vbms is defined by several environment variables:

- `VBMS_UPLOADER_BIN` - the full path to the ruby class that sends the document to VBMS; typically at connect_vbms/src/send.rb
- `VBMS_UPLOADER_ENV` - the name of the directory corresponding to the VBMS environment connect_vbms should connect to; the directory should contain security credentials for connecting to that VBMS environment.

### VLER-DAS integration

CUI integrates with the VA's Virtual Lifetime Electronic Record - Data Access Service (VLER-DAS) application.

The list of body systems that get sent to VLER-DAS is set by the `PHASE_2_BODY_SYSTEMS` environment variable. This variable should be a json-formatted list of body systems which should be sent to VLER-DAS; here's an example:
```
export PHASE_2_BODY_SYSTEMS='["Endocrine", "Genitourinary", "Mental Disorders"]'
```
If the environment variable `ENABLE_PHASE_2` is set to true and the body system is listed in the `PHASE_2_EVALUATIONS` list, the evaluation result will be sent to VLER-DAS instead of VBMS.

To set up VLER-DAS integration, there are a few environment variables that must be set, depending on your environment:

- `VLER_DAS_URL` - the URL to the ExamResponse transform endpoint
- `VLER_DAS_KEYFILE` - the full path to the private key used to generate your server's public certificate
- `VLER_DAS_KEYPASS` - the passphrase to the file specificed by VLER_DAS_KEYFILE; leave blank or do not set if no passphrase.
- `VLER_DAS_CERT` - your server's public cert (this should be provided to VLER-DAS).  It should be in PEM format.  If you have a file that is in DER format, you can convert it to PEM format using the following command:
```
openssl x509 -in /path/to/crt/file -outform pem -out /path/to/pem/file
```
- `VLER_DAS_CACERT` - the certificate chain to verify VLER-DAS; these are checked in to ssl/vler-das/
- `VLER_DAS_CIPHER_SUITES` - the cipher suites to use; VLER-DAS GOLD requires specific cipher suites (AES128-SHA or DES-CBC3-SHA). This is set in config/initializers/openssl.rb

### Disabling The Under Review Flag

For testing environments, you may want to allow people to create user accounts which don't need to be manually reviewed and have a default set of permissions.

If you set the CUI_DISABLE_UNDER_REVIEW environment variable to any value, users will not need to be reviewed, and they will be created with default roles of `medical_assistant` and `examiner`.

## SAML Configuration

The CUI Application performs external authentication using the Security
Assertion Markup Language (SAML) standard, separately for two external identity
providers: Single Sign On-internal (SSOi) and ID.me.  SSOi is a VA-internal
Single Sign-on authentication system that allows users to log on via PIV cards;
ID.me is an external system that uses the https://www.id.me/ service
to authenticate non-VA users.  Both authentication systems use
Devise to internally manage user credentials, but the SAML settings
must be configured separately.

### SSOi Configuration

CUI no longer uses `application-*.yml` files for storing SSOi configuration settings, and instead uses the environment variables below in a manner similar to environment variables in previous sections:

- `CALLBACK_URL`: SAML callback URL used exclusively for SSOi
- `ISSUER`: The SAML issuer used exclusively for SSOi.  **Note**: This issuer and the ID.me issuer will probably be one and teh same in future versions, but for now they are separate.
- `IDP_TARGET_URL`: The SSOi identity provider URL
- `CERTIFICATE`: This app's signed certificate used to establish a valid SSOi handshake with the identity provider (in full, without line breaks)
- `PRIVATE_KEY`: The SSOi private key certificate (in full, without line breaks)
- `NAME_IDENTIFIER_FORMAT`: SAML descriptor for the name identifier

**Note**: `config/initializers/devise.rb` has a secret key used by Devise. Devise uses this key to generate random tokens. Changing this key will render invalid all existing confirmation, reset password and unlock tokens in the database.  This is also unique to each environment and is also included in the `.gitignore` file.

### ID.me Configuration

ID.me is a separate SAML service that currently uses separate environment variables, as listed below:

- `SAML_CALLBACK`: SAML callback URL, as a route relative to the application host URL.
- `SAML_ISSUER`: The SAML issuer used exclusively used exclusively for ID.me, and currently set to the host URL.  **This is temporary and subject to change.**
- `SAML_LOGOUT`: The SLO (single-sign-on logout) URL that ID.me redirects to after the user logs out
- `SAML_METADATA_URL`: The ID.me identity provider metadata path
- `SAML_CERTIFICATE`: Relative path to certificate file (from application root) containing the app's signed certificate used to establish a valid ID.me handshake
- `SAML_KEY`: Relative path to private key file (from application root) used by identity provider to establish a valid ID.me handshake

## Making form validation errors 508 compliant

In order to highlight the fields/inputs/selects/labels, you can use the methods defined in the app/helpers/application_helper.rb

If the form is built differently than top to bottom, you can use the 'tabindex' attribute to give an appropriate ordering in which the tab keypress
moves focus.

The _va.scss file has been updated to change the alert color ($alert: #B50000). If you want to change the color of your validation errors, please ensure that the color contrast rule has been met: https://www.w3.org/WAI/WCAG20/quickref/#qr-visual-audio-contrast-contrast
