﻿using NVCC.Models;
using NVCC.Repos.UserRepository.dtoModels;
using System.Collections.Generic;
using System.Data.Entity;
using System.Data.SqlClient;
using System.Linq;

namespace NVCC.Repos.UserRepository
{
    public class UserContext : DbContext
    {
        public UserContext()
            : base("name=NwicPanelMgmtModel")
        {
        }

        public virtual DbSet<DtoUser> User { get; set; }
        public virtual DbSet<DtoUserFacility> UserFacility { get; set; }
        public virtual DbSet<MappedUser> VaUsers { get; set; } //to delete
        public virtual DbSet<StationInfo> StationInfo { get; set; }
        public IEnumerable<XdwUser> GetXdwUserByNetworkName (string networkName)
        {
            if (string.IsNullOrWhiteSpace(networkName))
            {
                return new List<XdwUser>();
            }
            else
            {
                return Database.SqlQuery<XdwUser>("EXEC App.NVCC_usp_GetXdwUser @username", new SqlParameter("username", networkName)).ToList();
            }
        }

        public IEnumerable<XdwFacility> GetXdwFacilitiesByLCustomerID (int? LCustomerID)
        {
            if (LCustomerID == null)
            {
                return new List<XdwFacility>();
            }
            else
            {
                return Database.SqlQuery<XdwFacility>("EXEC App.NVCC_usp_GetXdwFacility @LCustomerID", new SqlParameter("LCustomerID", LCustomerID)).ToList();
            }

        }

        public XdwFacility GetXdwFacilityBySta3n(short? Sta3n)
        {
            if (Sta3n == null)
            {
                return new XdwFacility();
            }
            else
            {
                return Database.SqlQuery<XdwFacility>("EXEC App.NVCC_usp_GetXdwFacilityBySta3n @Sta3n", new SqlParameter("Sta3n", Sta3n)).FirstOrDefault();
            }
        }

        public DtoUser GetUser(string UserName)
        {
            if (string.IsNullOrEmpty(UserName))
            {
                return null;
            }
            else
            {
                return Database.SqlQuery<DtoUser>("EXEC App.NVCC_usp_GetOrCreateUser @UserName", new SqlParameter("UserName", UserName)).FirstOrDefault();
            }
        }

        public int CheckUserAuthorization(string UserName)
        {
            if (string.IsNullOrEmpty(UserName))
            {
                return 0;
            }
            else
            {
                return Database.SqlQuery<int>("EXEC App.NVCC_usp_GetAuthorizedROIAdminUser @UserName", new SqlParameter("UserName", UserName)).FirstOrDefault();
            }
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Entity<DtoUser>().ToTable("NVCC_UsersV2", "App");
            modelBuilder.Entity<DtoUser>().HasKey(f => f.UserId);

            modelBuilder.Entity<DtoUserFacility>().ToTable("NVCC_UserFacilities", "App");
            modelBuilder.Entity<DtoUserFacility>().Property(t => t.UserId).HasColumnName("UserID");
            modelBuilder.Entity<DtoUserFacility>().Property(t => t.sta3n).HasColumnName("Sta3n");
            modelBuilder.Entity<DtoUserFacility>().Property(t => t.sta6a).HasColumnName("Sta6a");
            modelBuilder.Entity<DtoUserFacility>().HasKey(f => new { f.UserId, f.sta3n });

            // to delete
            modelBuilder.Entity<MappedUser>().ToTable("NVCC_Users", "App");
            modelBuilder.Entity<MappedUser>().Property(t => t.VaUserId).HasColumnName("ID");
            modelBuilder.Entity<MappedUser>().Property(t => t.Station).HasColumnName("Sta3n");
            modelBuilder.Entity<MappedUser>().HasKey(f => f.VaUserId);

            modelBuilder.Entity<StationInfo>().ToTable("NVCC_Stations", "App");
            modelBuilder.Entity<StationInfo>().Property(t => t.StationInfoId).HasColumnName("Sta3n");
            modelBuilder.Entity<StationInfo>().HasKey(f => f.StationInfoId);
        }
    }
}

