USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [App].[vPatient]
--=================================================================================
--Requestor		        : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name	    : vPatient
--SERVER		        : SERVER      
--Data Base		        : NWIC_PanelMgmt
--Schema		        : app
--Report		        : N/A
--Folder		        : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-18-2016 
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Purpose               : Retrieve a patient's recent appointments for inclusion
--                        into NVCC documentation
--=================================================================================
AS
   SELECT Cast(patientsid as varchar) as strPatientSID
         ,Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,PatientName
         ,PatientLastName
         ,PatientFirstName
         ,PatientSSN
         ,StreetAddress1
         ,StreetAddress2
         ,StreetAddress3
         ,City
         ,Zip
         ,Zip4
         ,PostalCode
         ,Province
         ,Country
         ,PhoneResidence
         ,PhoneWork
         ,PhoneCellular
         ,DateOfDeath
         ,BadAddressIndicator
         ,TemporaryAddressActiveFlag
         ,Gender
         ,Age
         ,[State]
         ,Deceased
         ,Eligibility
         ,DateOfBirth
         ,IneligibleDate
         ,EligibilityStatus
         ,EligibilityVerificationSource
   FROM  CDWWork.SPatient.SPatient;

GO