USE [NWIC_PanelMgmt]
GO

/****** Object:  StoredProcedure [app].[NVCC_usp_GetConsults]    Script Date: 1/12/2016 4:58:44 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [App].[vConsults]
--=================================================================================
--Requestor		        : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name	    : vGetAppts
--SERVER		        : SERVER       
--Data Base		        : NWIC_PanelMgmt
--Schema		        : app
--Report		        : N/A
--Folder		        : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-18-2016
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Purpose               : Retrieve a patient's consults from within the last 180
--                        days for inclusion into NVCC documentation.
--=================================================================================
AS
   SELECT
      c.Sta3n
     ,App.udf_StationName (c.Sta3n) AS StationName
     ,c.ToRequestServiceName
     ,cast(c.RequestDateTime as date) AS RequestDate
     ,c.CPRSStatus
     ,c.CPRSOrderSID
     ,c.Consultsid
   	 ,c.ConsultIEN
     ,c.PatientSID
     ,c.ToRequestServiceSID
     ,c.RequestType
   	 ,c.OrderStatusSID
     ,c.RecentActivityTypeSID
     ,c.RecentActivityType
   	 ,c.SendingStaffSID
     ,c.Urgency
     ,c.InpatOutpat
   	 ,iif(c.ProvisionalDiagnosis is null, ' ', c.ProvisionalDiagnosis) AS ProvDx
   	 ,iif(c.ProvisionalDiagnosisCode is null, ' ', c.ProvisionalDiagnosisCode) AS ProvDxCode
   	 ,c.TIUDocumentSID
     ,c.EarliestDate
     ,r.ConsultReason
   FROM CDWWork.Con.Consult c
   JOIN CDWWork.SPatient.SConsultReason r ON r.ConsultSID = c.ConsultSID
   WHERE c.ToRequestServiceName not like 'NON-FORM%' 
   	 AND c.CPRSStatus not in ('DISCONTINUED','CANCELLED','COMPLETE')
     AND c.RequestDateTime >= CAST(dateadd(dd, -180, getdate()) AS DATE);

GO