USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER VIEW [App].[NVCC_vGetVAMeds]

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_vGetVAMeds
--SERVER				: SERVER       
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-04-2016
--Last Changed          : 02-04-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's VA meds from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's medications issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================

WITH MyDrugs AS
   (-- Fake out Entity Framework into thinking this is a non-nullable column.
    SELECT ISNULL(RxOutpatFillSID, 0) AS RxOutpatFillSID
          ,[RxOutpatSID]
          ,[FillType]
          ,[FillNumber]
          ,[RxStatus]
          ,[PatientSID]
          ,[ProviderSID]
          ,[LocalDrugNameWithDose]
          ,[IssueDate]
          ,[FillDateTime]
          ,[ReleaseDateTime]
          ,[ExpirationDate]
          ,[DispensedDate]
          ,[Qty]
          ,[QtyNumeric]
          ,[DaysSupply]
          ,Row_Number()Over(partition by [RxOutpatSID] Order by [FillDateTime] desc) AS Rn
    FROM [CDWWork].[RxOut].[RxOutpatFill]
    WHERE dispenseddate > dateadd(year,-1,getdate())
   ),

     DrugsWSig AS
   (
    SELECT dl.rxoutpatsid
          ,dl.localdrugnamewithdose
          ,cast(dl.filldatetime as date) as filldate
          ,'Qty:' + dl.qty as qty
          ,dl.FillNumber
          ,sig.sig
          ,dl.issuedate
          ,dl.dayssupply
    FROM MyDrugs dl
    INNER JOIN CDWWork.RxOut.RxOutpatSig sig on dl.Rxoutpatsid=sig.RxOutpatSID
    WHERE dl.Rn = 1
   )

SELECT dl.rxoutpatsid
      ,dl.localdrugnamewithdose
      ,dl.filldate
      ,dl.qty
      ,dl.FillNumber
      ,iif(rx.maxrefills is null,'0',rx.maxrefills) as maxrefills
      ,dl.sig
      ,dl.issuedate
      ,dl.dayssupply
      ,rx.RxStatus
      ,iif(rx.NextPossibleFillDate is null,'N/A', cast(rx.NextPossibleFillDate as varchar)) as nextpossiblefilldate
FROM DrugsWSig dl
INNER JOIN [CDWWork].[RxOut].[RxOutpat] rx on dl.Rxoutpatsid = rx.RxOutpatSID;



GO


