--DROP PROCEDURE App.NVCC_usp_GetXdwFacility

USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE App.NVCC_usp_GetXdwFacility
	-- @LCustomerID is from CDWWork.LCustomer.LCustomer
	@LCustomerID int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwFacility
--Server                : SERVER       
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get the sites for which a user has PHI/PII access
--==================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.LCustomer.AllPermissions
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT
		s.Sta3n AS FacilityID
		,App.udf_StationName(s.Sta3n) AS FacilityName
		,s.VISNFY17 AS VISN
		,s.DistrictNumberFY17 AS District
	FROM CDWWork.LCustomer.AllPermissions AS ap
		JOIN CDWWork.Dim.Sta3n AS s
			ON ap.Sta3n = s.Sta3n
	WHERE 
		ap.LCustomerID = @LCustomerID 
		AND ap.PHIPII = 1 
		AND ap.Sta3n > 0
		AND s.Active = 'Y'
END
GO

exec sp_SignAppObject 'NVCC_usp_GetXdwFacility';

---- Test Cases
---- "Normal" user.
--exec app.NVCC_usp_GetXdwFacility 51773
---- 3 character site code not resolvable, no PHI/PII permissions
--exec app.NVCC_usp_GetXdwFacility 181938
-- -- No sites, no inferred site
--exec app.NVCC_usp_GetXdwFacility 611517
---- No inferred site, many (all?) PHIPPI permissions on sites
--exec app.NVCC_usp_GetXdwFacility 611694
---- No inferred sta3n, VISH, Region, or District, PHIPII pesrmission on 8 sites in VISN 20
--exec app.NVCC_usp_GetXdwFacility 13128
---- User who generated a NullReferenceException in User\UserInfo
--exec app.NVCC_usp_GetXdwFacility 279479
---- blank
--exec app.NVCC_usp_GetXdwFacility NULL
---- Non-existant name
--exec app.NVCC_usp_GetXdwFacility -20
