--DROP FUNCTION App.NVCC_udf_ActiveUserCount
USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION App.NVCC_udf_ActiveUserCount ()
RETURNS @ActiveUserCount TABLE
(
	Station varchar(50) NOT NULL,
	ActiveUsers int NOT NULL
)
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_udf_ActiveUserCount
--Server                : SERVER     
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To count the number of "active" users.
--==================================================================================
--Uses: NWIC_PanelMgmt.App.udf_StationName
--Uses: NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog
--Uses: CDWWork.Patient.Patient

-- NOTICE:
-- Do not edit the function live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.
BEGIN
	INSERT @ActiveUserCount
	SELECT
		App.udf_StationName(Sta3n) AS Station,
		COUNT(*) AS ActiveUsers
	FROM (
		SELECT al.UserID, p.Sta3n
		FROM
			NWIC_PanelMgmt.App.vNVCC_ProductionAccessLog al
			INNER JOIN CDWWork.Patient.Patient p
				ON al.PatientSID = p.PatientSID
		WHERE AccessDateTime > dateadd(day, -30, convert(date, getutcdate()))
		GROUP BY al.UserID, p.Sta3n
		HAVING COUNT(*) >= 10
	) AS U
	GROUP BY U.Sta3n
--	ORDER BY ActiveUsers DESC
	RETURN
END;
GO

exec sp_SignAppObject 'NVCC_udf_ActiveUserCount';
