-- CLEAR RECEIVING TABLES
TRUNCATE TABLE App.NVCC_UsersV2
TRUNCATE TABLE App.NVCC_UserFacilities

-- CEAR CORRUPT ACCOUNTS FROM ORIGINAL USER TABLE
DELETE App.NVCC_Users WHERE Sta3n = 0

-- INSERT TABLE VALUES
-- First put in user names to create userID
INSERT INTO App.NVCC_UsersV2
SELECT DomainPlusNetworkUserName AS UserName
FROM
	App.NVCC_Users

-- Second merge original user table to new to get the appropriate userID
-- cast columns and insert them
INSERT INTO App.NVCC_UserFacilities
SELECT
	App.NVCC_UsersV2.UserId,
	cast(NVCC_Users.Sta3n as smallint) AS Sta3n,
	cast(NVCC_Users.Sta6a as varchar(50)) AS Sta6a,
	cast(NVCC_Users.UserSessionSavedDateTime as datetime2(0)) AS LastAuthDateTime,
	NVCC_Users.ViaBApproved AS ViaB,
	ISNULL(NVCC_Users.[Admin], 0) AS [admin]
FROM
	App.NVCC_Users
	INNER JOIN App.NVCC_UsersV2
		ON NVCC_Users.DomainPlusNetworkUserName = App.NVCC_UsersV2.UserName

-- Report flags
-- Verify all the users exist
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'
exec App.NVCC_usp_GetOrCreateUser 'DOMAIN\USER'

-- Give them the report attribute
UPDATE App.NVCC_UsersV2
SET CanReport = 1
WHERE UserName IN 
(
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER'
,'DOMAIN\USER'
)

-- These accounts were already verified as exsiting before previous step
UPDATE App.NVCC_UsersV2
SET CanAnnounce = 1
WHERE UserName IN
(
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER',
'DOMAIN\USER'
)
