drop table #TestCandidates

select distinct top 500  c.Sta3n, b.TIUStandardTitle, a.TIUDocumentDefinitionPrintName, c.PatientSID, d.PatientSSN, d.PatientICN, d.PatientName
into #TestCandidates
from cdwwork.dim.tiudocumentdefinition a
join cdwwork.dim.tiustandardtitle b on b.TIUStandardTitleSID = a.TIUStandardTitleSID
join cdwwork.tiu.tiudocument c on c.tiudocumentdefinitionsid = a.tiudocumentdefinitionsid
join cdwwork.spatient.spatient d on d.PatientSID = c.PatientSID
where (tiudocumentdefinitionprintname like 'vha%choice%approv%10-038%')
and c.Sta3n=648
and (d.PatientName like 'zz%' OR
     d.TestPatientFlag = 'Y' or d.TestPatientFlag is NOT NULL OR
     d.patientSSN like '0000%')

delete from #TestCandidates where PatientSSN='000000100'  --This patient is TROUBLE.
delete from #TestCandidates where PatientSSN='209000051P' --SSN is too long for the app.

select * from #TestCandidates

--Pick one, what's s/he got?
DECLARE @PatientSID INT = '24257470',
        @PatientSta3n INT = 648,
        @PatientSSN VARCHAR(MAX) = '000000100'

EXEC [App].[NVCC_usp_GetPatient] @station = @PatientSta3n, @ssn = @PatientSSN
EXEC [App].[NVCC_usp_GetAllergies] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetAppts] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetConsults] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetLabs] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetNVAMeds] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetProbs] @PID = @PatientSID
--EXEC [App].[NVCC_usp_GetRadOrders] @PID = @PatientSID
--EXEC [App].[NVCC_usp_GetRadRpts] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetSensDx] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetVAMeds] @PID = @PatientSID
EXEC [App].[NVCC_usp_GetVisits] @PID = @PatientSID


select * from cdwwork.spatient.spatient where PatientSID = 17144708

INSERT INTO [App].[SSNToSID]
           ([Sta3n]
           ,[PatientSSN]
           ,[PatientSID]
           ,[PatientICN]
           ,[PatientName]
           ,[CPRSKey])
SELECT p.Sta3n
     , p.PatientSSN
     , p.PatientSID
     , p.PatientICN
     , p.PatientName
     , left(p.PatientName, 1) + ',' + right(p.PatientSSN, 4)
FROM CDWWork.SPatient.SPatient p
JOIN #TestCandidates c on p.PatientSID = c.PatientSID

select * from app.[SSNToSID] where PatientName like 'zz%' order by patientName

delete from app.[SSNToSID] where PatientName ='ZZTEST,ANNA'