use NWIC_PanelMgmt;   --your database here
                         --make sure the nva schema exists

if object_id('nva.Stations') is not null drop table nva.Stations;

create table nva.Stations (
   Sta3n int not null
  ,MedCtr varchar(60) not null
  ,Address varchar(130) null
  ,Server varchar(250) null
  ,DBase varchar(90) null 
  ,DSchema varchar(20) null
  ,TPAOK varchar(3) not null
  ,TPAName varchar(30) null
  ,NVAPhone varchar(20) null
  ,FAXPhone varchar(20) null );

insert into nva.Stations (
   Sta3n
  ,MedCtr
  ,Address
  ,Server
  ,DBase 
  ,DSchema
  ,TPAOK
  ,TPAName
  ,NVAPhone
  ,FAXPhone
  ) values
 (648,'VA Portland HCS V4-PCD','3710 SW US Veterans Hospital Rd, Portland, OR 97239'
    ,'Description=DataWarehouse;DRIVER=SQL Server;SERVER=r01scrdwh50;Trusted_Connection=Yes;DATABASE=NWIC_PanelMgmt'
    ,'NWIC_PanelMgmt','nva','Yes','Tri-West','360-795-1674','360-905-1731')
;

insert into nva.Stations (
   Sta3n
  ,MedCtr
  ,Address
  ,Server
  ,DBase 
  ,DSchema
  ,TPAOK
  ,TPAName
  ,NVAPhone
  ,FAXPhone
  ) values
 (648,'Boise VAMC','500 W Fort St, Boise, ID  83702'
    ,'Description=DataWarehouse;DRIVER=SQL Server;SERVER=r01scrdwh50;Trusted_Connection=Yes;DATABASE=NWIC_PanelMgmt'
    ,'NWIC_PanelMgmt','nva','Yes','Tri-West','208-422-1252','208-422-1290')
;

--select * from nva.stations

IF OBJECT_ID('nva.PutStation', 'P') IS NOT NULL
    DROP PROCEDURE nva.PutStation ;
GO
CREATE PROCEDURE nva.PutStation
   @station int
  ,@MedCtr varchar(60)
  ,@Address varchar(130)
  ,@Server varchar(250)
  ,@DBase varchar(90)
  ,@DSchema varchar(20)
  ,@TPAOK varchar(3)
  ,@TPAName varchar(30)
  ,@NVAPhone varchar(20)
  ,@faxphone varchar(20)
AS
begin
declare @checkstation int;
set @checkstation = (select top 1 sta3n from nva.stations where sta3n=@station)
if  @checkstation is null -- then it doesn't exist, let's add it
  begin
  insert into nva.stations (
       sta3n
	  ,MedCtr 
	  ,Address
	  ,Server
	  ,DBase
	  ,DSchema
	  ,TPAOK
	  ,TPAName
	  ,NVAPhone
	  ,faxphone) 
	values (
       @station
	  ,@MedCtr 
	  ,@Address
	  ,@Server
	  ,@DBase
	  ,@DSchema
	  ,@TPAOK
	  ,@TPAName
	  ,@NVAPhone
	  ,@faxphone);
  --also need to insert the structure for the lab linkages
  insert into nva.labselections (sta3n,ctrlname) values
	(@station,'Hgb'),
	(@station,'Hct'),
	(@station,'WBC'),
	(@station,'Plts'),
	(@station,'INR'),
	(@station,'Tchol'),
	(@station,'HDL'),
	(@station,'LDL'),
	(@station,'TGA'),
	(@station,'RA'),
	(@station,'ANA'),
	(@station,'Na'),
	(@station,'K'),
	(@station,'Cl'),
	(@station,'CO2'),
	(@station,'BUN'),
	(@station,'Cr'),
	(@station,'Glu'),
	(@station,'A1C'),
	(@station,'AST'),
	(@station,'ALT'),
	(@station,'Tbili');
	return 1;
  end
else
  begin
    --station already exists, need to update
	update nva.stations set
	   MedCtr=@MedCtr 
	  ,Address=@Address
	  ,Server=@Server
	  ,DBase=@DBase
	  ,DSchema=@DSchema
	  ,TPAOK=@TPAOK
	  ,TPAName=@TPAName
	  ,NVAPhone=@NVAPhone
	  ,faxphone=@FaxPhone where sta3n=@station;
  end
end
go

IF OBJECT_ID('nva.GetStations', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetStations ;
GO
CREATE PROCEDURE nva.GetStations

AS
BEGIN
	SET NOCOUNT ON;
	SELECT * from nva.Stations;
END
GO

IF OBJECT_ID('nva.GetStation', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetStation ;
GO
CREATE  PROCEDURE [nva].[GetStation]
	@station int --station to get information for

AS
BEGIN
	SET NOCOUNT ON;
	SELECT * from nva.Stations where Sta3n=@station;
END
go
--To add a station, follow this example with your own data
--this should be done using SQL
/*
exec nva.PutStation 
       @station= 000
	  ,@MedCtr = 'My Med Center'
	  ,@Address = '123 my street, City, State, ZipCode'
	  ,@Server = 'Description=DataWarehouse;DRIVER=SQL Server;SERVER=SERVER;Trusted_Connection=Yes;DATABASE=S000_My_DataBase'
	  ,@DBase = 'S000_My_DataBase'
	  ,@DSchema = 'nva'
	  ,@TPAOK = 'YES' --typically this is yes, otherwise no
	  ,@TPAName = 'HealthNet'
	  ,@NVAPhone = '800-555-1111'
	  ,@faxphone) = '800-555-2222';
*/


if object_id('nva.DocTypes') is not null drop table nva.DocTypes;
go
create table nva.DocTypes (
   DocName varchar(35) not null 
  ,DocType varchar(10) not null
  ,RadOrd varchar(3) not null
  ,Ndx int not null
  );

insert into nva.DocTypes (
   DocName  
  ,DocType 
  ,RadOrd
  ,Ndx 
  ) values
('Choice First','TPA','No',1),
('Veterans Choice List','TPA','No',2),
('NVCC','Non-VA','No',3),
('Radiology Order (Choice)','TPA','Yes',4),
('Radiology Order (Non-VA/Non-TPA)','Non-VA','Yes',5),
('PC3','TPA','No',6);

IF OBJECT_ID('nva.GetDocTypes', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetDocTypes ;
GO
CREATE PROCEDURE nva.GetDocTypes
AS
BEGIN
	SET NOCOUNT ON;
	SELECT * from nva.Doctypes order by ndx;
END
GO

if object_id('nva.labselections') is not null drop table nva.labselections;

create table nva.labselections (
   sta3n int not null       -- this is the station to which these codes apply
  ,testname varchar(50) null --this is the local name for the test
  ,ctrlname varchar(20) not null --this is the program's name for the test, DO NOT CHANGE
  ,testsid varchar(20) null -- this is the labchemSID for this test in text format
  ); 


--exec nva.GetLabSelections @station=508  
--Lab values for Atlanta
--The station number is important, of course, the second field is the
--Local name for the test, though does not maatter for the program to
--function. The third field is critical, and must not be altered. That
--is how the program know what it is. The fourth field is the database
--SID that when combined with the PatientSID identifies the test to be
--resulted to produce the value for this test.
Insert into nva.labselections (sta3n,testname,ctrlname,testsid) values
(648,'HGB','Hgb','800075498'),
(648,'HCT','Hct','800071489'),
(648,'WBC','WBC','800076472'),
(648,'PLT','Plts','800040423'),
(648,'INR','INR','800071474'),
(648,'CHOLESTEROL','Tchol','800075487'),
(648,'DIRECT HDL','HDL','800075108'),
(648,'LDL-CHOL(CALCULATED)','LDL','800063906'),
(648,'TRIGLYCERIDE','TGA','800070879'),
(648,'RHEUMATOID FACT 3752','RA','800001079'),
(648,'ANA','ANA','800000696'),
(648,'SODIUM','Na','800075473'),
(648,'POTASSIUM','K','800000724'),
(648,'CHLORIDE','Cl','800074766'),
(648,'CO2','CO2','800074767'),
(648,'UREA NITROGEN','BUN','800077694'),
(648,'CREATININE','Cr','800074765'),
(648,'GLUCOSE','Glu','800077696'),
(648,'HGB A1C %','A1C','800040429'),
(648,'AST (SGOT)','AST','800074778'),
(648,'ALT (SGPT)','ALT','800073657'),
(648,'TOT. BILIRUBIN','Tbili','800077713');


/****** Object:  StoredProcedure [nva].[GetLabSelections]    Script Date: 9/29/2015 4:45:28 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF OBJECT_ID('nva.GetLabSelections', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetLabSelections ;
GO
Create PROCEDURE [nva].[GetLabSelections]
   @station int
AS
BEGIN
	SET NOCOUNT ON;
    select testname, ctrlname, testsid from nva.labselections where sta3n=@station ;
END
go

if object_id('nva.HIPAATerms') is not null drop table nva.HIPAATerms;

create table nva.HIPAATerms (
   term varchar(35) not null 
  );

insert into nva.HIPAATerms (
  term) values
('hiv')
,('sickle')
,('drug')
,('abuse')
,('cocaine')
,('alcohol')
,('etoh')
,('immunodeficiency')
,('heroin')
,('cannabis')
,('thc')
,('amphetamine')
,('methamphetamine')
,('disulfiram')
,('antabuse')
,('hgbss')
,('kaposi');

IF OBJECT_ID('nva.AddHIPAATerm', 'P') IS NOT NULL
    DROP PROCEDURE nva.AddHIPAATerm ;
GO
CREATE PROCEDURE nva.AddHIPAATerm
   @newterm varchar(35)
AS
BEGIN
	SET NOCOUNT ON;
	select term into #t1 from nva.HIPAATerms where term like @newterm;
	
	declare @cnt int;
	set @cnt = (select count(*) from #t1);
	if @cnt=0
	  begin
	    insert into nva.HIPAATerms (
            term) values (@newterm);
	  end;
	return 0;
END
GO

--exec nva.AddHIPAATerm @newterm='crack';

IF OBJECT_ID('nva.DeleteHIPAATerm', 'P') IS NOT NULL
    DROP PROCEDURE nva.DeleteHIPAATerm ;
GO
CREATE PROCEDURE nva.DeleteHIPAATerm
   @badterm varchar(35)
AS
BEGIN
	SET NOCOUNT ON;
	delete from nva.HIPAATerms where term like @badterm;
	return 0;
END
GO

IF OBJECT_ID('nva.GetHIPAATerms', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetHIPAATerms ;
GO
CREATE PROCEDURE nva.GetHIPAATerms
  
AS
BEGIN
	SET NOCOUNT ON;
	select * from nva.HIPAATerms;
	return 0;
END
GO

--exec nva.GetHIPAATerms;


if object_id('nva.NVASettings') is not null drop table nva.NVASettings;
go
create table nva.NVASettings (
   usr varchar(25) not null --userID to whom this parameter applied
  ,sta3n int null--station if applicable
  ,parm varchar(25) not null --name of setting
  ,pvalue varchar(2000) not null --parameter value
  );
go

IF OBJECT_ID('nva.Parm', 'P') IS NOT NULL
    DROP PROCEDURE nva.Parm ;
GO
CREATE  PROCEDURE [nva].[parm]
	@station int --station to get information for, used primarily for globals
   ,@parmname varchar(25)     --Name of setting (parameter)
   ,@parmvalue varchar(2000)  --Always provide a default value, if the parameter does not
                              --exist, this value will be used to create the parameter
   ,@putget varchar(3) -- 'Get' to get a parameter, 'Put' to store a parameter
   ,@global varchar(3) -- 'Yes' if don't care about user or station,
                       -- 'Stn' if only care about station, 'No' if user specific
AS
BEGIN
declare @result as varchar(1000);
set @result = @parmvalue;
	SET NOCOUNT ON;
    if @putget like 'PUT' 
	  begin
	  if @global like 'No'
        begin
          UPDATE nva.NVASettings set
		  pvalue=@parmvalue where usr like CURRENT_USER and sta3n=@station and parm=@parmname;
		  if @@rowcount =0 
		    begin
              insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue); 
            end
		end
	  else if @global like 'Stn' 
        begin
          UPDATE nva.NVASettings set
		   usr=CURRENT_USER 
		  ,pvalue=@parmvalue where sta3n=@station and parm=@parmname
		  if @@rowcount =0 
		    begin
              insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue); 
            end
		  end 
		
      else 
	    begin
          UPDATE nva.NVASettings set
		   usr=CURRENT_USER 
		  ,sta3n=@station
		  ,pvalue=@parmvalue where parm=@parmname
          if @@rowcount =0 
		    begin
              insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue); 
            end
		end
      end
	else --putget is not 'put' so must be get
      begin
	    if @global like 'No'
		begin 
	    set @result = (select top 1 pvalue from nva.NVASettings where parm like @parmname 
		     and usr like CURRENT_USER and Sta3n = @station);
          if @result is null
		    begin
              set @result = @parmvalue;
			  insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue);
		    end
		end
		else if @global like 'Stn'
        begin
		  set @result = (select top 1 pvalue from nva.NVASettings where parm like @parmname 
		     and Sta3n = @station);
          if @result is null
		    begin
              set @result = @parmvalue;
			  insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue); 
            end
		end
		else
        begin
		  set @result = (select top 1 pvalue from nva.NVASettings where parm like @parmname);
          if @result is null
		    begin
              set @result = @parmvalue;
			  insert into nva.NVASettings (usr,sta3n,parm,pvalue) values
			   (current_user, @station,@parmname,@parmvalue); 
            end
         end
	end
select @result as parametervalue;
--exec nva.parm @station=508,@parmvalue='666',@parmname='parm2',@putget='PUT',@global='No'
end
go


if object_id('nva.SensitiveDxCodes') is not null drop table nva.SensitiveDxCodes;

create table nva.SensitiveDxCodes (
   CodingSystem varchar(12) not null
  ,Code varchar(12) not null
  ,DiagnosisText varchar(250) not null
  ,AbuseDx int
  ,SickleDx int
  ,HIVDx int );

IF OBJECT_ID('nva.GetSensDxCodes', 'P') IS NOT NULL
    DROP PROCEDURE nva.GetSensDxCodes;
GO
create PROCEDURE [nva].[GetSensDxCodes]
	-- Add the parameters for the stored procedure here
	-- 
AS
BEGIN
--This procedure gets the sensitive diagnosis code list. It is not station specific 
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
SELECT [CodingSystem]
      ,[Code]
      ,[DiagnosisText]
      ,[AbuseDx]
      ,[SickleDx]
      ,[HIVDx]
  FROM [nva].[SensitiveDxCodes];
end;
go

insert into nva.SensitiveDxCodes (
   CodingSystem 
  ,Code 
  ,DiagnosisText
  ,AbuseDx 
  ,SickleDx
  ,HIVDx) values ('ICD9','282.42','THLASSEMIA HB-S W CRISIS',0,1,0),
('ICD9','282.59','SICKLE-CELL TRAIT, OTHER',0,1,0),
('ICD9','282.64','HB-S/HB-C DIS W CRISIS',0,1,0),
('ICD9','282.68','HB-S DIS W/O CRISIS NEC',0,1,0),
('ICD9','V78.2','SCREEN-SICKLE CELL DIS',0,0,1),
('ICD9','043.2','HIV CAUSE OTH IMMUNE DIS',0,0,1),
('ICD9','042.1','HIV CAUSING OTHER SPEC INF',0,0,1),
('ICD9','176.8','KAPOSI''S SARCOMA, OTHER SITES',0,0,1),
('ICD9','795.8','POSITIVE SERO/VIRAL HIV',0,0,1),
('ICD9','176.2','KAPOSI''S SARCOMA, PALATE',0,0,1),
('ICD9','042.2','HIV WITH SPEC MALIGNANT NEO',0,0,1),
('ICD9','176.9','KAPOSI''S SARCOMA, NOS',0,0,1),
('ICD9','043.9','HIV-ARC, UNSPECIFIED',0,0,1),
('ICD9','042.0','HIV WITH SPECIFIED INFECTIONS',0,0,1),
('ICD9','176.4','KAPOSI''S SARCOMA, LUNG',0,0,1),
('ICD9','044.9','HIV INFECTION UNSPECIFIED',0,0,1),
('ICD9','176.3','KAPOSI''S SARCOMA, GI SITES',0,0,1),
('ICD9','176.5','KAPOSI''S SARCOMA, LYMPH NODES',0,0,1),
('ICD9','042.9','HIV-AIDS UNSPECIFIED',0,0,1),
('ICD9','043.3','HIV CAUSE OTHER SPEC DISORDERS',0,0,1),
('ICD9','176.1','KAPOSI''S SARCOMA, SOFT TISSUE',0,0,1),
('ICD9','043.1','HIV CAUSING SPEC DISEASE-CNS',0,0,1),
('ICD9','176.0','KAPOSI''S SARCOMA, SKIN',0,0,1),
('ICD9','795.71','NONSPEC SEROL EVID OF HIV',0,0,1),
('ICD9','079.53','HIV 2',0,0,1),
('ICD9','079.51','HTLV-I',0,0,1),
('ICD9','079.59','OTHER SPEC RETROVIRUS',0,0,1),
('ICD9','079.52','HTLV-II',0,0,1),
('ICD9','042.','HIV DISEASE',0,0,1),
('ICD9','V08.','ASYMPT HIV STATUS',0,0,1),
('ICD9','V65.44','HIV COUNSELING',0,0,1),
('ICD9','291.1','ALCOHOL AMNESTIC DISORDR',1,0,0),
('ICD9','291.2','ALCOHOL PERSIST DEMENTIA',1,0,0),
('ICD9','291.3','ALCOH PSY DIS W HALLUCIN',1,0,0),
('ICD9','291.4','PATHOLOGIC ALCOHOL INTOX',1,0,0),
('ICD9','291.5','ALCOH PSYCH DIS W DELUS',1,0,0),
('ICD9','291.8','ALCOHOLIC PSYCHOSIS NEC',1,0,0),
('ICD9','291.9','ALCOHOL MENTAL DISOR NOS',1,0,0),
('ICD9','292.84','DRUG-INDUCED MOOD DISORD',1,0,0),
('ICD9','304.41','AMPHETAMINE DEPENDENCE CONT',1,0,0),
('ICD9','304.13','SED,HYP,ANXIOLYT DEP-REM',1,0,0),
('ICD9','305.02','ALCOHOL ABUSE-EPISODIC',1,0,0),
('ICD9','303.01','AC ALCOHOL INTOX-CONTIN',1,0,0),
('ICD9','304.72','OPIOID+OTHER DEP-EPISOD',1,0,0),
('ICD9','305.23','CANNABIS ABUSE-IN REMISS',1,0,0),
('ICD9','305.52','OPIOID ABUSE EPISODIC',1,0,0),
('ICD9','304.51','HALLUCINOGEN DEPENDENCE CONT',1,0,0),
('ICD9','304.93','DRUG DEPEND NOS-REMISS',1,0,0),
('ICD9','304.63','DRUG DEPEND OTH-IN REM',1,0,0),
('ICD9','305.32','HALLUCINOG ABUSE-EPISOD',1,0,0),
('ICD9','357.5','ALCOHOLIC POLYNEUROPATHY',1,0,0),
('ICD9','304.03','OPIOID DEPENDENCE IN REMISSION',1,0,0),
('ICD9','305.72','AMPHETAMINE ABUSE-EPISODIC',1,0,0),
('ICD9','305.82','ANTIDEPRESS ABUSE-EPISOD',1,0,0),
('ICD9','304.81','COMB DRUG DEP NEC-CONTIN',1,0,0),
('ICD9','305.21','CANNABIS ABUSE-CONTIN',1,0,0),
('ICD9','305.62','COCAINE ABUSE-EPISODIC',1,0,0),
('ICD9','305.81','ANTIDEPRESS ABUSE-CONTIN',1,0,0),
('ICD9','304.02','OPIOID DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.73','OPIOID+OTHER DEP-REMISS',1,0,0),
('ICD9','305.31','HALLUCINOG ABUSE-CONTIN',1,0,0),
('ICD9','305.71','AMPHETAMINE ABUSE-CONTINUOUS',1,0,0),
('ICD9','305.33','HALLUCINOG ABUSE-REMISS',1,0,0),
('ICD9','304.53','HALLUCINOGEN DEPENDENCE IN REM',1,0,0),
('ICD9','305.91','OTHER DRUG ABUSE-CONTIN',1,0,0),
('ICD9','304.32','CANNABIS DEPENDENCE EPISODIC',1,0,0),
('ICD9','305.43','SED,HYP,ANXIOLYTC AB-REM',1,0,0),
('ICD9','304.52','HALLUCINOGEN DEPENDENCE EPISOD',1,0,0),
('ICD9','304.31','CANNABIS DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','305.73','AMPHETAMINE ABUSE-REMISS',1,0,0),
('ICD9','303.92','ALCOH DEP NEC/NOS-EPISOD',1,0,0),
('ICD9','305.83','ANTIDEPRESS ABUSE-REMISS',1,0,0),
('ICD9','304.11','SED,HYP,ANXIOLYT DEP-CON',1,0,0),
('ICD9','305.93','OTHER DRUG ABUSE-REMISS',1,0,0),
('ICD9','305.41','SED,HYP,ANXIOLYTC AB-CON',1,0,0),
('ICD9','303.03','AC ALCOHOL INTOX-REMISS',1,0,0),
('ICD9','305.53','OPIOID ABUSE IN REMISSION',1,0,0),
('ICD9','304.43','AMPHETAMINE DEPENDENCE IN REM',1,0,0),
('ICD9','304.83','COMB DRUG DEP NEC-REMISS',1,0,0),
('ICD9','305.12','TOBACCO ABUSE-EPISODIC',1,0,0),
('ICD9','304.22','COCAINE DEPEND-EPISODIC',1,0,0),
('ICD9','303.02','AC ALCOHOL INTOX-EPISOD',1,0,0),
('ICD9','304.62','DRUG DEPEND OTH-EPISODIC',1,0,0),
('ICD9','305.22','CANNABIS ABUSE-EPISODIC',1,0,0),
('ICD9','304.12','SED,HYP,ANXIOLYT DEP-EPI',1,0,0),
('ICD9','304.71','OPIOID+OTHER DEP-CONTIN',1,0,0),
('ICD9','304.01','OPIOID DEPENDENCE CONT',1,0,0),
('ICD9','305.51','OPIOID ABUSE CONTINUOUS',1,0,0),
('ICD9','305.92','OTHER DRUG ABUSE-EPISOD',1,0,0),
('ICD9','304.42','AMPHETAMINE DEPENDENCE EPISOD',1,0,0),
('ICD9','303.91','ALCOH DEP NEC/NOS-CONTIN',1,0,0),
('ICD9','304.21','COCAINE DEPEND-CONTIN',1,0,0),
('ICD9','305.61','COCAINE ABUSE-CONTINUOUS',1,0,0),
('ICD9','304.61','DRUG DEPEND OTH-CONTIN',1,0,0),
('ICD9','304.39','OTHER CANNABIS DEPEND, NEC',1,0,0),
('ICD9','305.01','ALCOHOL ABUSE-CONTINUOUS',1,0,0),
('ICD9','305.42','SED,HYP,ANXIOLYTC AB-EPI',1,0,0),
('ICD9','305.11','TOBACCO ABUSE-CONTINUOUS',1,0,0),
('ICD9','303.93','ALCOH DEP NEC/NOS-REMISS',1,0,0),
('ICD9','304.23','COCAINE DEPEND-REMISS',1,0,0),
('ICD9','305.03','ALCOHOL ABUSE-IN REMISS',1,0,0),
('ICD9','304.92','DRUG DEPEND NOS-EPISODIC',1,0,0),
('ICD9','304.91','UNSPEC DRUG DEPEND CONTIN',1,0,0),
('ICD9','305.13','TOBACCO ABUSE-IN REMISS',1,0,0),
('ICD9','305.63','COCAINE ABUSE-IN REMISS',1,0,0),
('ICD9','304.50','HALLUCINOGEN DEPENDENCE UNSPEC',1,0,0),
('ICD9','305.80','ANTIDEPRESS ABUSE-UNSPEC',1,0,0),
('ICD9','304.80','COMB DRUG DEP NEC-UNSPEC',1,0,0),
('ICD9','305.00','ALCOHOL ABUSE-UNSPEC',1,0,0),
('ICD9','304.10','SED,HYP,ANXIOLYT DEP-NOS',1,0,0),
('ICD9','305.30','HALLUCINOG ABUSE-UNSPEC',1,0,0),
('ICD9','305.90','OTHER DRUG ABUSE-UNSPEC',1,0,0),
('ICD9','305.70','AMPHETAMINE ABUSE-UNSPECIFIED',1,0,0),
('ICD9','304.00','OPIOID DEPENDENCE UNSPECIFIED',1,0,0),
('ICD9','305.1','TOBACCO USE DISORDER',1,0,0),
('ICD9','305.6','COCAINE ABUSE-UNSPEC',1,0,0),
('ICD9','304.30','CANNABIS DEPENDENCE UNSPEC',1,0,0),
('ICD9','304.40','AMPHETAMINE DEPENDENCE UNSPEC',1,0,0),
('ICD9','304.20','COCAINE DEPEND-UNSPEC',1,0,0),
('ICD9','291.0','DELIRIUM TREMENS',1,0,0),
('ICD9','305.40','SED,HYP,ANXIOLYTC AB-NOS',1,0,0),
('ICD9','304.60','DRUG DEPEND OTH-UNSPEC',1,0,0),
('ICD9','303.90','ALCOH DEP NEC/NOS-UNSPEC',1,0,0),
('ICD9','304.70','OPIOID+OTHER DEP-UNSPEC',1,0,0),
('ICD9','303.00','AC ALCOHOL INTOX-UNSPEC',1,0,0),
('ICD9','305.20','CANNABIS ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.90','UNSPEC DRUG DEPEND NEC UNSPEC',1,0,0),
('ICD9','305.50','OPIOID ABUSE UNSPECIFIED',1,0,0),
('ICD9','V11.3','HX OF ALCOHOLISM',1,0,0),
('ICD9','304.122','MEPROBAMATE DEPENDENCE EPISODI',1,0,0),
('ICD9','304.49','OTHER PSYCHOSTIM DEPEND',1,0,0),
('ICD9','305.502','MORPHINE ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.428','BARBITURATES ABUSE EPISODIC',1,0,0),
('ICD9','305.329','OTHER HALLUCINOGEN ABUSE EPISO',1,0,0),
('ICD9','305.408','BARBITURATES ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.511','METHADONE ABUSE CONTINUOUS',1,0,0),
('ICD9','305.929','OTHER MIXED/UNSPEC DRUG ABUSE',1,0,0),
('ICD9','305.709','OTHER RELATED ACTING SYMPATHOM',1,0,0),
('ICD9','305.422','MEPROBAMATE ABUSE EPISODIC',1,0,0),
('ICD9','304.129','OTHER SEDATIVE OR HYPNOTIC DEP',1,0,0),
('ICD9','305.46','VALIUM, DIAZEPAM ABUSE',1,0,0),
('ICD9','305.423','NOLUDAR METHYPRYLOME ABUSE EPI',1,0,0),
('ICD9','305.523','OPIUM ABUSE EPISODIC',1,0,0),
('ICD9','304.421','PRELUDIN DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.33','CANNABIS DEPENDENCE IN REMISS',1,0,0),
('ICD9','305.79','OTHER SYMPATHOMIMETIC, NEC',1,0,0),
('ICD9','305.417','DORIDEN GLUTETHIMIDE ABUSE CON',1,0,0),
('ICD9','305.519','OTHER OPIOD ABUSE NEC CONTINUO',1,0,0),
('ICD9','304.539','OTHER HALLUCINOGEN DEPENDENCE',1,0,0),
('ICD9','305.701','PRELUDIN ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.239','OTHER CANNABIS ABUSE IN REMISS',1,0,0),
('ICD9','304.104','PARALDEHYDE DEPENDENCE UNSPECI',1,0,0),
('ICD9','304.919','UNSPECIFIED DRUG DEPENDENCE NE',1,0,0),
('ICD9','305.731','PRELUDIN ABUSE IN REMISSION',1,0,0),
('ICD9','304.411','PRELUDIN DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','304.15','PLACIDYL, ETHCHLORUYNOL DEPEND',1,0,0),
('ICD9','291.21','DEMENTIA ASSOC W/ETOH, MILD',1,0,0),
('ICD9','304.137','DORIDEN GLUTETHIMIDE DEPENDENC',1,0,0),
('ICD9','304.109','OTHER SEDATIVE OR HYPNOTIC DEP',1,0,0),
('ICD9','305.436','VALIUM DIAZEPAM ABUSE IN REMIS',1,0,0),
('ICD9','304.401','PRELUDIN DEPENDENCE UNSPECIFIE',1,0,0),
('ICD9','304.132','MEPROBAMATE DEPENDENCE IN REMI',1,0,0),
('ICD9','305.405','PLACIDYL ETHCHLORUYNOL ABUSE U',1,0,0),
('ICD9','291.20','DEMENTIA ASSOC W/ETOH, UNSPEC',1,0,0),
('ICD9','305.439','OTHER SEDATIVE OR HYPNOTIC ABU',1,0,0),
('ICD9','304.126','VALIUM DIAZEPAM DEPENDENCE EPI',1,0,0),
('ICD9','305.229','OTHER CANNABIS ABUSE EPISODIC',1,0,0),
('ICD9','304.14','PARALDEHYDE DEPENDENCE',1,0,0),
('ICD9','305.59','OTHER OPIOID ABUSE, NEC',1,0,0),
('ICD9','304.309','OTHER CANNABIS DEPENDENCE UNSP',1,0,0),
('ICD9','304.113','NOLUDAR METHYPRYLOME DEPENDENC',1,0,0),
('ICD9','305.719','OTHER RELATED ACTING SYMPATHOM',1,0,0),
('ICD9','304.127','DORIDEN GLUTETHIMIDE DEPENDENC',1,0,0),
('ICD9','305.412','MEPROBAMATE ABUSE CONTINUOUS',1,0,0),
('ICD9','305.939','OTHER MIXED/UNSPEC DRUG ABUSE',1,0,0),
('ICD9','305.531','METHADONE ABUSE IN REMISSION',1,0,0),
('ICD9','304.18','BARBITURATE DEPENDENCE',1,0,0),
('ICD9','304.09','OTHER OPIOID TYPE DEPEN, NEC',1,0,0),
('ICD9','304.106','VALIUM DIAZEPAM DEPENDENCE UNS',1,0,0),
('ICD9','304.431','PRELUDIN DEPENDENCE IN REMISSI',1,0,0),
('ICD9','304.929','UNSPECIFIED DRUG DEPENDENCE NE',1,0,0),
('ICD9','305.418','BARBITURATES ABUSE CONTINUOUS',1,0,0),
('ICD9','304.409','OTHER PSYCHOSTIMULANT DEPENDEN',1,0,0),
('ICD9','304.133','NOLUDAR METHYPRYLOME DEPENDENC',1,0,0),
('ICD9','305.432','MEPROBAMATE ABUSE IN REMISSION',1,0,0),
('ICD9','291.23','DEMENTIA ASSOC W/ETOH SEVERE',1,0,0),
('ICD9','304.339','OTHER CANNABIS DEPENDENCE IN R',1,0,0),
('ICD9','305.522','MORPHINE ABUSE EPISODIC',1,0,0),
('ICD9','304.429','OTHER PSYCHOSTIMULANT DEPENDEN',1,0,0),
('ICD9','305.404','PARALDEHYDE ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.135','PLACIDYL ETHCHLORUYNOL DEPENDE',1,0,0),
('ICD9','304.19','OTHER SEDATIVE OR HYPNOTIC',1,0,0),
('ICD9','304.105','PLACIDYL ETHCHLORUYNOL DEPENDE',1,0,0),
('ICD9','304.021','METHADONE DEPENDENCE EPISODIC',1,0,0),
('ICD9','305.402','MEPROBAMATE ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.45','PLACIDYL, ETHCHLORUYNOL ABUSE',1,0,0),
('ICD9','304.103','NOLUDAR METHYPRYLOME DEPENDENC',1,0,0),
('ICD9','305.434','PARALDEHYDE ABUSE IN REMISSION',1,0,0),
('ICD9','304.102','MEPROBAMATE DEPENDENCE UNSPECI',1,0,0),
('ICD9','304.115','PLACIDYL ETHCHLORUYNOL DEPENDE',1,0,0),
('ICD9','304.125','PLACIDYL ETHCHLORUYNOL DEPENDE',1,0,0),
('ICD9','305.431','LIBRIUM ABUSE IN REMISSION',1,0,0),
('ICD9','304.002','MORPHINE DEPENDENCE UNSPECIFIE',1,0,0),
('ICD9','304.033','OPIUM DEPENDENCE IN REMISSION',1,0,0),
('ICD9','305.209','OTHER CANNABIS ABUSE UNSPECIFI',1,0,0),
('ICD9','305.437','DORIDEN GLUTETHIMIDE ABUSE IN',1,0,0),
('ICD9','304.011','METHADONE DEPENDENCE CONTINUOU',1,0,0),
('ICD9','304.112','MEPROBAMATE DEPENDENCE CONTINU',1,0,0),
('ICD9','304.118','BARBITURATES DEPENDENCE CONTIN',1,0,0),
('ICD9','304.329','OTHER CANNABIS DEPENDENCE EPIS',1,0,0),
('ICD9','304.032','MORPHINE DEPENDENCE IN REMISSI',1,0,0),
('ICD9','305.421','LIBRIUM ABUSE EPISODIC',1,0,0),
('ICD9','305.401','LIBRIUM ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.124','PARALDEHYDE DEPENDENCE EPISODI',1,0,0),
('ICD9','304.107','DORIDEN GLUTETHIMIDE DEPENDENC',1,0,0),
('ICD9','304.131','LIBRIUM DEPENDENCE IN REMISSIO',1,0,0),
('ICD9','304.138','BARBITURATES DEPENDENCE IN REM',1,0,0),
('ICD9','305.429','OTHER SEDATIVE OR HYPNOTIC ABU',1,0,0),
('ICD9','305.435','PLACIDYL ETHCHLORUYNOL ABUSE I',1,0,0),
('ICD9','304.003','OPIUM DEPENDENCE UNSPECIFIED',1,0,0),
('ICD9','304.101','LIBRIUM DEPENDENCE UNSPECIFIED',1,0,0),
('ICD9','304.16','VALIUM, DIAZEPAM DEPEND',1,0,0),
('ICD9','305.406','VALIUM DIAZEPAM ABUSE UNSPECIF',1,0,0),
('ICD9','304.99','UNSPEC DRUG DEPEND, NEC',1,0,0),
('ICD9','304.108','BARBITURATES DEPENDENCE UNSPEC',1,0,0),
('ICD9','305.219','OTHER CANNABIS ABUSE CONTINUOU',1,0,0),
('ICD9','305.438','BARBITURATES ABUSE IN REMISSIO',1,0,0),
('ICD9','304.031','METHADONE DEPENDENCE IN REMISS',1,0,0),
('ICD9','304.013','OPIUM DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','304.134','PARALDEHYDE DEPENDENCE IN REMI',1,0,0),
('ICD9','304.319','OTHER CANNABIS DEPENDENCE CONT',1,0,0),
('ICD9','304.012','MORPHINE DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','305.403','NOLUDAR METHYPRYLOME ABUSE UNS',1,0,0),
('ICD9','305.29','OTHER CANNABIS USE, NEC',1,0,0),
('ICD9','305.513','OPIUM ABUSE CONTINUOUS',1,0,0),
('ICD9','305.414','PARALDEHYDE ABUSE CONTINUOUS',1,0,0),
('ICD9','304.509','OTHER HALLUCINOGEN DEPENDENCE',1,0,0),
('ICD9','305.427','DORIDEN GLUTETHIMIDE ABUSE EPI',1,0,0),
('ICD9','305.309','OTHER HALLUCINOGEN ABUSE UNSPE',1,0,0),
('ICD9','304.029','OTHER OPIOD DEPENDENCE EPISODI',1,0,0),
('ICD9','305.503','OPIUM ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.47','DORIDEN, GLUTETHIMIDE ABUSE',1,0,0),
('ICD9','305.407','DORIDEN GLUTETHIMIDE ABUSE UNS',1,0,0),
('ICD9','305.919','OTHER MIXED/UNSPEC DRUG ABUSE',1,0,0),
('ICD9','305.509','OTHER OPIOD ABUSE NEC UNSPECIF',1,0,0),
('ICD9','305.411','LIBRIUM ABUSE CONTINUOUS',1,0,0),
('ICD9','305.909','OTHER MIXED/UNSPEC DRUG ABUSE',1,0,0),
('ICD9','304.117','DORIDEN GLUTETHIMIDE DEPENDENC',1,0,0),
('ICD9','305.711','PRELUDIN ABUSE CONTINUOUS',1,0,0),
('ICD9','305.48','BARBITURATES ABUSE',1,0,0),
('ICD9','305.532','MORPHINE ABUSE IN REMISSION',1,0,0),
('ICD9','305.426','VALIUM DIAZEPAM ABUSE EPISODIC',1,0,0),
('ICD9','304.419','OTHER PSYCHOSTIMULANT DEPENDEN',1,0,0),
('ICD9','304.121','LIBRIUM DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.023','OPIUM DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.001','METHADONE DEPENDENCE UNSPECIFI',1,0,0),
('ICD9','305.433','NOLUDAR METHYPRYLOME ABUSE IN',1,0,0),
('ICD9','305.533','OPIUM ABUSE IN REMISSION',1,0,0),
('ICD9','304.019','OTHER OPIOD DEPENDENCE CONTINU',1,0,0),
('ICD9','305.512','MORPHINE ABUSE CONTINUOUS',1,0,0),
('ICD9','304.519','OTHER HALLUCINOGEN DEPENDENCE',1,0,0),
('ICD9','305.44','PARALDEHYDE ABUSE',1,0,0),
('ICD9','305.319','OTHER HALLUCINOGEN ABUSE CONTI',1,0,0),
('ICD9','305.339','OTHER HALLUCINOGEN ABUSE IN RE',1,0,0),
('ICD9','304.022','MORPHINE DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.939','UNSPECIFIED DRUG DEPENDENCE NE',1,0,0),
('ICD9','304.116','VALIUM DIAZEPAM DEPENDENCE CON',1,0,0),
('ICD9','305.99','OTHER, MIXED, UNSPEC, NEC',1,0,0),
('ICD9','304.909','UNSPECIFIED DRUG DEPENDENCE NE',1,0,0),
('ICD9','305.49','OTHER SEDATIVE OR HYPNOT, NEC',1,0,0),
('ICD9','304.039','OTHER OPIOD DEPENDENCE IN REMI',1,0,0),
('ICD9','305.416','VALIUM DIAZEPAM ABUSE CONTINUO',1,0,0),
('ICD9','304.009','OTHER OPIOD DEPENDENCE UNSPECI',1,0,0),
('ICD9','305.425','PLACIDYL ETHCHLORUYNOL ABUSE E',1,0,0),
('ICD9','304.111','LIBRIUM DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','305.39','OTHER HALLUCINOGEN ABUSE, NEC',1,0,0),
('ICD9','304.119','OTHER SEDATIVE OR HYPNOTIC DEP',1,0,0),
('ICD9','305.415','PLACIDYL ETHCHLORUYNOL ABUSE C',1,0,0),
('ICD9','304.128','BARBITURATES DEPENDENCE EPISOD',1,0,0),
('ICD9','304.136','VALIUM DIAZEPAM DEPENDENCE IN',1,0,0),
('ICD9','304.139','OTHER SEDATIVE OR HYPNOTIC DEP',1,0,0),
('ICD9','304.17','DORIDEN, GLUTETHIMIDE DEPEND',1,0,0),
('ICD9','305.409','OTHER SEDATIVE OR HYPNOTIC ABU',1,0,0),
('ICD9','304.123','NOLUDAR METHYPRYLOME DEPENDENC',1,0,0),
('ICD9','305.413','NOLUDAR METHYPRYLOME ABUSE CON',1,0,0),
('ICD9','305.529','OTHER OPIOD ABUSE NEC EPISODIC',1,0,0),
('ICD9','304.439','OTHER PSYCHOSTIMULANT DEPENDEN',1,0,0),
('ICD9','305.721','PRELUDIN ABUSE EPISODIC',1,0,0),
('ICD9','305.419','OTHER SEDATIVE OR HYPNOTIC ABU',1,0,0),
('ICD9','305.539','OTHER OPIOD ABUSE NEC IN REMIS',1,0,0),
('ICD9','305.424','PARALDEHYDE ABUSE EPISODIC',1,0,0),
('ICD9','305.739','OTHER RELATED ACTING SYMPATHOM',1,0,0),
('ICD9','304.114','PARALDEHYDE DEPENDENCE CONTINU',1,0,0),
('ICD9','305.521','METHADONE ABUSE EPISODIC',1,0,0),
('ICD9','304.529','OTHER HALLUCINOGEN DEPENDENCE',1,0,0),
('ICD9','305.729','OTHER RELATED ACTING SYMPATHOM',1,0,0),
('ICD9','304.59','OTHER HALLUCINOGEN DEPEND',1,0,0),
('ICD9','291.22','DEMENTIA ASSOC W/ETOH, MOD',1,0,0),
('ICD9','305.501','METHADONE ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.430','AMPHETAMINE DEPENDENCE IN REMI',1,0,0),
('ICD9','304.930','PHENCYCLIDINE (PCP) DEPENDENCE',1,0,0),
('ICD9','305.60','COCAINE ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.410','CHLORAL HYDRATE ABUSE CONTINUO',1,0,0),
('ICD9','304.610','PCP DEPENDENCE, CONTINUOUS',1,0,0),
('ICD9','305.310','LSD ABUSE CONTINUOUS',1,0,0),
('ICD9','304.900','PHENCYCLIDINE (PCP) DEPENDENCE',1,0,0),
('ICD9','305.400','CHLORAL HYDRATE ABUSE UNSPECIF',1,0,0),
('ICD9','305.210','MARIJUANA ABUSE CONTINUOUS',1,0,0),
('ICD9','305.910','PHENCYCLIDINE (PCP) ABUSE (INC',1,0,0),
('ICD9','304.619','OTHER SPEC DRUG DEPEND, CONT',1,0,0),
('ICD9','304.310','MARIJUANA DEPENDENCE CONTINUOU',1,0,0),
('ICD9','305.900','PHENCYCLIDINE (PCP) ABUSE (INC',1,0,0),
('ICD9','304.510','LSD DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','305.730','AMPHETAMINE ABUSE IN REMISSION',1,0,0),
('ICD9','304.400','AMPHETAMINE DEPENDENCE UNSPECI',1,0,0),
('ICD9','305.300','LSD ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.000','HEROIN DEPENDENCE UNSPECIFIED',1,0,0),
('ICD9','305.220','MARIJUANA ABUSE EPISODIC',1,0,0),
('ICD9','304.520','LSD DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.300','MARIJUANA DEPENDENCE UNSPECIFI',1,0,0),
('ICD9','305.330','LSD ABUSE IN REMISSION',1,0,0),
('ICD9','305.720','AMPHETAMINE ABUSE EPISODIC',1,0,0),
('ICD9','305.230','MARIJUANA ABUSE IN REMISSION',1,0,0),
('ICD9','305.10','TOBACCO USE DISORDER UNSPECIFI',1,0,0),
('ICD9','304.629','OTHER SPEC DRUG DEPEND',1,0,0),
('ICD9','304.120','CHLORAL HYDRATE DEPENDENCE EPI',1,0,0),
('ICD9','304.010','HEROIN DEPENDENCE CONTINUOUS',1,0,0),
('ICD9','305.700','AMPHETAMINE ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.330','MARIJUANA DEPENDENCE IN REMISS',1,0,0),
('ICD9','304.320','MARIJUANA DEPENDENCE EPISODIC',1,0,0),
('ICD9','304.020','HEROIN DEPENDENCE EPISODIC',1,0,0),
('ICD9','305.530','HEROIN ABUSE IN REMISSION',1,0,0),
('ICD9','304.420','AMPHETAMINE DEPENDENCE EPISODI',1,0,0),
('ICD9','304.030','HEROIN DEPENDENCE IN REMISSION',1,0,0),
('ICD9','305.520','HEROIN ABUSE EPISODIC',1,0,0),
('ICD9','304.639','OTHER SPEC DRUG DEPEND, REMISS',1,0,0),
('ICD9','304.620','PCP DEPENDENCE, EPISODIC',1,0,0),
('ICD9','304.630','PCP DEPEND IN REMISSION',1,0,0),
('ICD9','304.910','PHENCYCLIDINE (PCP) DEPENDENCE',1,0,0),
('ICD9','305.920','PHENCYCLIDINE (PCP) ABUSE (INC',1,0,0),
('ICD9','304.100','CHLORAL HYDRATE DEPENDENCE UNS',1,0,0),
('ICD9','304.609','OTHER SPEC DRUG DEPEND, UNSPEC',1,0,0),
('ICD9','304.110','CHLORAL HYDRATE DEPENDENCE CON',1,0,0),
('ICD9','304.410','AMPHETAMINE DEPENDENCE CONTINU',1,0,0),
('ICD9','305.710','AMPHETAMINE ABUSE CONTINUOUS',1,0,0),
('ICD9','305.430','CHLORAL HYDRATE ABUSE IN REMIS',1,0,0),
('ICD9','304.920','PHENCYCLIDINE (PCP) DEPENDENCE',1,0,0),
('ICD9','304.130','CHLORAL HYDRATE DEPENDENCE IN',1,0,0),
('ICD9','305.510','HEROIN ABUSE CONTINUOUS',1,0,0),
('ICD9','305.420','CHLORAL HYDRATE ABUSE EPISODIC',1,0,0),
('ICD9','304.500','LSD DEPENDENCE UNSPECIFIED',1,0,0),
('ICD9','305.930','PHENCYCLIDINE (PCP) ABUSE (INC',1,0,0),
('ICD9','304.530','LSD DEPENDENCE IN REMISSION',1,0,0),
('ICD9','305.500','HEROIN ABUSE UNSPECIFIED',1,0,0),
('ICD9','305.320','LSD ABUSE EPISODIC',1,0,0),
('ICD9','305.200','MARIJUANA ABUSE UNSPECIFIED',1,0,0),
('ICD9','304.600','PCP DEPENDENCE, UNSPECIFIED',1,0,0),
('ICD9','291.89','ALCOHOL MENTAL DISOR NEC',1,0,0),
('ICD9','V65.42','COUNSEL-SUBS USE/ABUSE',1,0,0),
('ICD9','291.81','ALCOHOL WITHDRAWAL',1,0,0),
('ICD9','291.82','ALCOH INDUCE SLEEP DISOR',1,0,0),
('ICD9','282.5','SICKLE-CELL TRAIT',0,1,0),
('ICD9','282.61','HB-SS DISEASE W/O CRISIS',0,1,0),
('ICD9','282.62','HB-SS DISEASE W CRISIS',0,1,0),
('ICD9','282.63','HB-SS/HB-C DIS W/O CRSIS',0,1,0),
('ICD9','282.69','HB-SS DIS NEC W CRISIS',0,1,0),
('ICD9','282.60','SICKLE CELL DISEASE NOS',0,1,0),
('ICD9','282.44','SICKLE-CELL THALASSEMIA',0,1,0),
('ICD9','282.41','THLASEMA HB-S W/O CRISIS',0,1,0),
('ICD9','282.50','SICKLE-CELL TRAIT HB-AS GENO',0,1,0),
('ICD9','282.64','HB-S/HB-C DIS W CRISIS',0,1,0),
('ICD9','282.65','SICKLE-CELL DISEASE/HB-E',0,1,0),

('ICD10','B20.','Human immunodeficiency virus [HIV] disease', 0,0,1),
('ICD10','B33.3','Retrovirus infections, not elsewhere classified', 0,0,1),
('ICD10','B97.33','HTLV-I as the cause of diseases classified elsewhere', 0,0,1),
('ICD10','B97.34','HTLV-II as the cause of diseases classified elsewhere', 0,0,1),
('ICD10','B97.35','HIV 2 as the cause of diseases classified elsewhere', 0,1,0),
('ICD10','B97.35','HIV 2 as the cause of diseases classified elsewhere', 0,0,1),
('ICD10','B97.39','Oth retrovirus as the cause of diseases classified elsewhere', 0,0,1),
('ICD10','C46.0','KAPOSI''S sarcoma of skin', 0,0,1),
('ICD10','C46.1','KAPOSI''S sarcoma of soft tissue', 0,0,1),
('ICD10','C46.2','KAPOSI''S sarcoma of palate', 0,0,1),
('ICD10','C46.3','KAPOSI''S sarcoma of lymph nodes', 0,0,1),
('ICD10','C46.4','KAPOSI''S sarcoma of gastrointestinal sites', 0,0,1),
('ICD10','C46.50','KAPOSI''S sarcoma of unspecified lung', 0,0,1),
('ICD10','C46.7','KAPOSI''S sarcoma of other sites', 0,0,1),
('ICD10','C46.9','KAPOSI''S sarcoma, unspecified', 0,0,1),
('ICD10','D56.1','Beta thalassemia', 0,1,0),
('ICD10','D57.00','Hb-SS disease with crisis, unspecified', 0,1,0),
('ICD10','D57.1','Sickle-cell disease without crisis', 0,1,0),
('ICD10','D57.1','Sickle-cell disease without crisis', 0,1,0),
('ICD10','D57.20','Sickle-cell/Hb-C disease without crisis', 0,1,0),
('ICD10','D57.219','Sickle-cell/Hb-C disease with crisis, unspecified', 0,1,0),
('ICD10','D57.219','Sickle-cell/Hb-C disease with crisis, unspecified', 0,1,0),
('ICD10','D57.3','Sickle-cell trait', 0,1,0),
('ICD10','D57.40','Sickle-cell thalassemia without crisis', 0,1,0),
('ICD10','D57.419','Sickle-cell thalassemia with crisis, unspecified', 0,1,0),
('ICD10','D57.80','Other sickle-cell disorders without crisis', 0,1,0),
('ICD10','D57.819','Other sickle-cell disorders with crisis, unspecified', 0,1,0),
('ICD10','F10.10','Alcohol abuse, uncomplicated', 1,0,0),
('ICD10','F10.10','Alcohol abuse, uncomplicated', 1,0,0),
('ICD10','F10.10','Alcohol abuse, uncomplicated', 1,0,0),
('ICD10','F10.10','Alcohol abuse, uncomplicated', 1,0,0),
('ICD10','F10.159','Alcohol abuse with alcohol-induced psychotic disorder, unsp', 1,0,0),
('ICD10','F10.180','Alcohol abuse with alcohol-induced anxiety disorder', 1,0,0),
('ICD10','F10.181','Alcohol abuse with alcohol-induced sexual dysfunction', 1,0,0),
('ICD10','F10.182','Alcohol abuse with alcohol-induced sleep disorder', 1,0,0),
('ICD10','F10.188','Alcohol abuse with other alcohol-induced disorder', 1,0,0),
('ICD10','F10.20','Alcohol dependence, uncomplicated', 1,0,0),
('ICD10','F10.20','Alcohol dependence, uncomplicated', 1,0,0),
('ICD10','F10.20','Alcohol dependence, uncomplicated', 1,0,0),
('ICD10','F10.21','Alcohol dependence, in remission', 1,0,0),
('ICD10','F10.229','Alcohol dependence with intoxication, unspecified', 1,0,0),
('ICD10','F10.229','Alcohol dependence with intoxication, unspecified', 1,0,0),
('ICD10','F10.229','Alcohol dependence with intoxication, unspecified', 1,0,0),
('ICD10','F10.229','Alcohol dependence with intoxication, unspecified', 1,0,0),
('ICD10','F10.231','Alcohol dependence with withdrawal delirium', 1,0,0),
('ICD10','F10.239','Alcohol dependence with withdrawal, unspecified', 1,0,0),
('ICD10','F10.259','Alcohol dependence w alcoh-induce psychotic disorder, unsp', 1,0,0),
('ICD10','F10.27','Alcohol dependence with alcohol-induced persisting dementia', 1,0,0),
('ICD10','F10.280','Alcohol dependence with alcohol-induced anxiety disorder', 1,0,0),
('ICD10','F10.281','Alcohol dependence with alcohol-induced sexual dysfunction', 1,0,0),
('ICD10','F10.282','Alcohol dependence with alcohol-induced sleep disorder', 1,0,0),
('ICD10','F10.288','Alcohol dependence with other alcohol-induced disorder', 1,0,0),
('ICD10','F10.929','Alcohol use, unspecified with intoxication, unspecified', 1,0,0),
('ICD10','F10.950','Alcohol use, unsp w alcoh-induce psych disorder w delusions', 1,0,0),
('ICD10','F10.951','Alcohol use, unsp w alcoh-induce psych disorder w hallucin', 1,0,0),
('ICD10','F10.959','Alcohol use, unsp w alcohol-induced psychotic disorder, unsp', 1,0,0),
('ICD10','F10.96','Alcohol use, unsp w alcoh-induce persist amnestic disorder', 1,0,0),
('ICD10','F10.980','Alcohol use, unsp with alcohol-induced anxiety disorder', 1,0,0),
('ICD10','F10.982','Alcohol use, unspecified with alcohol-induced sleep disorder', 1,0,0),
('ICD10','F10.99','Alcohol use, unsp with unspecified alcohol-induced disorder', 1,0,0),
('ICD10','F11.10','Opioid abuse, uncomplicated', 1,0,0),
('ICD10','F11.10','Opioid abuse, uncomplicated', 1,0,0),
('ICD10','F11.10','Opioid abuse, uncomplicated', 1,0,0),
('ICD10','F11.10','Opioid abuse, uncomplicated', 1,0,0),
('ICD10','F11.20','Opioid dependence, uncomplicated', 1,0,0),
('ICD10','F11.20','Opioid dependence, uncomplicated', 1,0,0),
('ICD10','F11.20','Opioid dependence, uncomplicated', 1,0,0),
('ICD10','F11.21','Opioid dependence, in remission', 1,0,0),
('ICD10','F12.10','Cannabis abuse, uncomplicated', 1,0,0),
('ICD10','F12.10','Cannabis abuse, uncomplicated', 1,0,0),
('ICD10','F12.10','Cannabis abuse, uncomplicated', 1,0,0),
('ICD10','F12.10','Cannabis abuse, uncomplicated', 1,0,0),
('ICD10','F12.20','Cannabis dependence, uncomplicated', 1,0,0),
('ICD10','F12.20','Cannabis dependence, uncomplicated', 1,0,0),
('ICD10','F12.20','Cannabis dependence, uncomplicated', 1,0,0),
('ICD10','F12.21','Cannabis dependence, in remission', 1,0,0),
('ICD10','F12.90','Cannabis use, unspecified, uncomplicated', 1,0,0),
('ICD10','F12.90','Cannabis use, unspecified, uncomplicated', 1,0,0),
('ICD10','F12.90','Cannabis use, unspecified, uncomplicated', 1,0,0),
('ICD10','F13.10','Sedative, hypnotic or anxiolytic abuse, uncomplicated', 1,0,0),
('ICD10','F13.10','Sedative, hypnotic or anxiolytic abuse, uncomplicated', 1,0,0),
('ICD10','F13.10','Sedative, hypnotic or anxiolytic abuse, uncomplicated', 1,0,0),
('ICD10','F13.10','Sedative, hypnotic or anxiolytic abuse, uncomplicated', 1,0,0),
('ICD10','F13.20','Sedative, hypnotic or anxiolytic dependence, uncomplicated', 1,0,0),
('ICD10','F13.20','Sedative, hypnotic or anxiolytic dependence, uncomplicated', 1,0,0),
('ICD10','F13.20','Sedative, hypnotic or anxiolytic dependence, uncomplicated', 1,0,0),
('ICD10','F13.21','Sedative, hypnotic or anxiolytic dependence, in remission', 1,0,0),
('ICD10','F14.10','Cocaine abuse, uncomplicated', 1,0,0),
('ICD10','F14.10','Cocaine abuse, uncomplicated', 1,0,0),
('ICD10','F14.10','Cocaine abuse, uncomplicated', 1,0,0),
('ICD10','F14.10','Cocaine abuse, uncomplicated', 1,0,0),
('ICD10','F14.20','Cocaine dependence, uncomplicated', 1,0,0),
('ICD10','F14.20','Cocaine dependence, uncomplicated', 1,0,0),
('ICD10','F14.20','Cocaine dependence, uncomplicated', 1,0,0),
('ICD10','F14.21','Cocaine dependence, in remission', 1,0,0),
('ICD10','F15.10','Other stimulant abuse, uncomplicated', 1,0,0),
('ICD10','F15.10','Other stimulant abuse, uncomplicated', 1,0,0),
('ICD10','F15.10','Other stimulant abuse, uncomplicated', 1,0,0),
('ICD10','F15.10','Other stimulant abuse, uncomplicated', 1,0,0),
('ICD10','F15.20','Other stimulant dependence, uncomplicated', 1,0,0),
('ICD10','F15.20','Other stimulant dependence, uncomplicated', 1,0,0),
('ICD10','F15.20','Other stimulant dependence, uncomplicated', 1,0,0),
('ICD10','F15.21','Other stimulant dependence, in remission', 1,0,0),
('ICD10','F16.10','Hallucinogen abuse, uncomplicated', 1,0,0),
('ICD10','F16.10','Hallucinogen abuse, uncomplicated', 1,0,0),
('ICD10','F16.10','Hallucinogen abuse, uncomplicated', 1,0,0),
('ICD10','F16.10','Hallucinogen abuse, uncomplicated', 1,0,0),
('ICD10','F16.20','Hallucinogen dependence, uncomplicated', 1,0,0),
('ICD10','F16.20','Hallucinogen dependence, uncomplicated', 1,0,0),
('ICD10','F16.20','Hallucinogen dependence, uncomplicated', 1,0,0),
('ICD10','F16.21','Hallucinogen dependence, in remission', 1,0,0),
('ICD10','F17.200','Nicotine dependence, unspecified, uncomplicated', 1,0,0),
('ICD10','F18.10','Inhalant abuse, uncomplicated', 1,0,0),
('ICD10','F18.10','Inhalant abuse, uncomplicated', 1,0,0),
('ICD10','F18.10','Inhalant abuse, uncomplicated', 1,0,0),
('ICD10','F18.10','Inhalant abuse, uncomplicated', 1,0,0),
('ICD10','F19.10','Other psychoactive substance abuse, uncomplicated', 1,0,0),
('ICD10','F19.10','Other psychoactive substance abuse, uncomplicated', 1,0,0),
('ICD10','F19.10','Other psychoactive substance abuse, uncomplicated', 1,0,0),
('ICD10','F19.10','Other psychoactive substance abuse, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.20','Other psychoactive substance dependence, uncomplicated', 1,0,0),
('ICD10','F19.21','Other psychoactive substance dependence, in remission', 1,0,0),
('ICD10','F19.21','Other psychoactive substance dependence, in remission', 1,0,0),
('ICD10','F19.21','Other psychoactive substance dependence, in remission', 1,0,0),
('ICD10','F19.21','Other psychoactive substance dependence, in remission', 1,0,0),
('ICD10','F19.94','Oth psychoactive substance use, unsp w mood disorder', 1,0,0),
('ICD10','G62.1','Alcoholic polyneuropathy', 1,0,0),
('ICD10','O98.711','Human immunodef virus disease comp preg, first trimester', 0,1,0),
('ICD10','O98.712','Human immunodef virus disease comp preg, second trimester', 0,1,0),
('ICD10','O98.713','Human immunodef virus disease comp preg, third trimester', 0,1,0),
('ICD10','O98.719','Human immunodef virus disease comp pregnancy, unsp trimester', 0,1,0),
('ICD10','O98.72','Human immunodeficiency virus disease complicating childbirth', 0,1,0),
('ICD10','O98.73','Human immunodef virus disease complicating the puerperium', 0,1,0),
('ICD10','R75.','Inconclusive laboratory evidence of human immunodef virus', 0,0,1),
('ICD10','Z13.0','Encntr screen for dis of the bld/bld-form org/immun mechnsm', 0,0,1),
('ICD10','Z21.','Asymptomatic human immunodeficiency virus infection status', 0,1,0),
('ICD10','Z21.','Asymptomatic human immunodeficiency virus infection status', 0,0,1),
('ICD10','Z65.8','Oth problems related to psychosocial circumstances', 1,0,0),
('ICD10','Z71.41','Alcohol abuse counseling and surveillance of alcoholic', 1,0,0),
('ICD10','Z71.7','Human immunodeficiency virus [HIV] counseling', 0,0,1);

--select * from nva.SensitiveDxCodes;
