﻿$(function () {
    var spinneropts = {
        lines: 10, // The number of lines to draw
        length: 10, // The length of each line
        width: 4, // The line thickness
        radius: 10, // The radius of the inner circle
        corners: 1, // Corner roundness (0..1)
        rotate: 0, // The rotation offset
        direction: 1, // 1: clockwise, -1: counterclockwise
        color: "#fff", // #rgb or #rrggbb or array of colors
        speed: 1.5, // Rounds per second
        trail: 50, // Afterglow percentage
        shadow: false, // Whether to render a shadow
        hwaccel: false, // Whether to use hardware acceleration
        className: "spinner", // The CSS class to assign to the spinner
        zIndex: 2e9, // The z-index (defaults to 2000000000)
        top: "50%", // Top position relative to parent in px
        left: "50%" // Left position relative to parent in px

    };
    var target = document.getElementById("Spinner");
    var spinner = new Spinner(spinneropts).spin(target);
    $("#Spinner").hide();
    spinner.stop(target);
   
    $("#SubmitButton").click(function () {
            $("#SubmitButton").attr("disabled", true);
            spinner.spin(target);
            $("#Spinner").show();
    });

    var ajaxCnt = 0; // Support for parallel AJAX requests

    $(document).ajaxStart(function () {
        ajaxCnt++;
        if (ajaxCnt === 1) {
            spinner.spin(target);
            $("#Spinner").show();
        }
    });

    $(document)
        .ajaxStop(function() {
            ajaxCnt--;
            if (ajaxCnt === 0) {
                spinner.stop();
                $("#Spinner").hide();
            }
    });
});