﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using NVCC.WebUI.Models;
using NVCC.Models;

namespace NVCC.WebUI.Infrastructure
{
    public class RoiService : IRoiService
    {
        private readonly IPatientRepository _patientRepository;
        private readonly IAodRepository _aodRepository;

        public RoiService(IPatientRepository patientRepository, IAodRepository aodRepository)
        {
            _patientRepository = patientRepository;
            _aodRepository = aodRepository;
        }

        public IEnumerable<RoiSearchResult> RoiSearch(string lastFourOfSsn, string lastNamePartial, string firstFiveOfSsn = null, string firstNamePartial = null, DateTime? startDate = default(DateTime?), DateTime? endDate = default(DateTime?))
        {
            var matchingPatients = _patientRepository.GetPatientsByNameAndSsn(lastFourOfSsn, lastNamePartial, firstFiveOfSsn, firstNamePartial);

            var results = new List<RoiSearchResult>();

            foreach (var patient in matchingPatients)
            {
                var disclosures = _aodRepository.GetPatientDisclosures(patient.PatientIcn, startDate, endDate);
                if (disclosures != null && disclosures.Any())
                {
                    var result = new RoiSearchResult
                    {
                        Patient = patient,
                        Disclosures = disclosures
                    };

                    //adding this ONLY BECAUSE natures weren't being saved with some test data at first. SHOULD BE REMOVED:
                    foreach (var disclosure in result.Disclosures)
                    {
                        if (disclosure.Natures == null || !disclosure.Natures.Any())
                        {
                            disclosure.Natures = _aodRepository.GetAllNatures();
                        }
                    }
                    

                    results.Add(result);
                }
            }

            return results;
        }

        public Disclosure GetDisclosureById(int disclosureId)
        {
            return _aodRepository.GetDisclosureById(disclosureId);
        }

        public IEnumerable<ROIAdminSearch> GetRoiAdminSearchResults(short sta3n, short visn, DateTime? startDate, DateTime? endDate, string userId)
        {
            var adminSearchResults = _aodRepository.GetRoiAdminSearchResults(sta3n, visn, startDate, endDate, userId);
            return adminSearchResults;
        }

        public List<UserByFacility> GetUsersByFacilityId(int sta6a)
        {
            return _aodRepository.GetUsersByFacilityId(sta6a);
        }

        public Disclosure EditDisclosureMadeTo(Disclosure editedDisclosure, bool isRoiAdmin, string userId)
        {
            return _aodRepository.EditDisclosureMadeTo(editedDisclosure, isRoiAdmin, userId);
        }
    }
}